%define pypi_name testtools
%define mod_name %pypi_name

%def_with check

Name: python3-module-%pypi_name
Version: 2.7.2
Release: alt2
Summary: Extensions to the Python standard library's unit testing framework
License: MIT
Group: Development/Python3
URL: https://pypi.org/project/testtools
VCS: https://github.com/testing-cabal/testtools
BuildArch: noarch
Source: %name-%version.tar
Patch: testtools-2.7.2-twisted-test-fix.patch

%add_python3_req_skip twisted

BuildRequires(pre): rpm-build-python3
BuildRequires: python3-module-hatchling
BuildRequires: python3-module-hatch-vcs
BuildRequires: python3-module-setuptools-scm

%if_with check
# tests are subpackaged
BuildRequires: python3-module-twisted-core-tests
BuildRequires: python3-module-testscenarios
%endif

%description
testtools is a set of extensions to the Python standard library's unit
testing framework. These extensions have been derived from years of
experience with unit testing in Python and come from many different
sources.

%prep
%setup
%patch -p1

%build
export SETUPTOOLS_SCM_PRETEND_VERSION=%version
%pyproject_build

%install
%pyproject_install

%check
%pyproject_run -- python -m testtools.run testtools.tests.test_suite

%files
%doc LICENSE NEWS README*
%python3_sitelibdir/%mod_name/
%python3_sitelibdir/%{pyproject_distinfo %pypi_name}/

%changelog
