%define _unpackaged_files_terminate_build 1
%define oname sphinx

%def_enable docs
%def_enable check

%define sphinx3_dir %python3_sitelibdir_noarch/%oname

# should be synced to Requires-Dist
%define dependencies \\\
python3(sphinxcontrib.applehelp) \\\
python3(sphinxcontrib.devhelp) \\\
python3(sphinxcontrib.jquery) \\\
python3(sphinxcontrib.jsmath) \\\
python3(sphinxcontrib.htmlhelp) \\\
python3(sphinxcontrib.serializinghtml) \\\
python3(sphinxcontrib.qthelp) \\\
python3(jinja2) \\\
python3(Pygments) \\\
python3(docutils) \\\
python3(snowballstemmer) \\\
python3(babel) \\\
python3(alabaster) \\\
python3(imagesize) \\\
python3(requests) \\\
python3(packaging) \\\
python3(defusedxml) \\\
python3(roman_numerals) \\\
%nil

Name: python3-module-%oname
Epoch: 1
Version: 8.2.1
Release: alt1

Summary: Tool for producing documentation for Python projects
License: BSD
Group: Development/Python3
Url: http://sphinx-doc.org
VCS: https://github.com/sphinx-doc/sphinx

BuildArch: noarch

# Source0-url: https://github.com/sphinx-doc/sphinx/archive/refs/tags/v%version.tar.gz
Source0: sphinx-%version.tar.gz
Source1: conf.py.template
Source2: macro3
Source3: refcounting.py

Patch1: %oname-alt-tests-offline.patch
Patch2: python-sphinx-objects.patch

Requires: python3-module-sphinx-sphinx-build-symlink
Requires: %(echo "%dependencies")
Provides: python3-module-objects.inv
Obsoletes: python3-module-objects.inv

BuildRequires(pre): rpm-build-python3
BuildRequires: python-sphinx-objects.inv
BuildRequires: /usr/bin/convert

# build backend and its deps
BuildRequires: python3(flit_core)
BuildRequires: python3(wheel)

%if_enabled docs
# synced to .[docs]
BuildRequires: %(echo "%dependencies")
BuildRequires: python3(sphinxcontrib.websupport)
BuildRequires: graphviz
BuildRequires: fonts-ttf-dejavu
%endif

%if_enabled check
# synced to .[test]
BuildRequires: %(echo "%dependencies")
BuildRequires: python3(pytest)
BuildRequires: python3(html5lib)
BuildRequires: python3(cython)
BuildRequires: python3(filelock)
%endif

%add_python3_self_prov_path %buildroot%python3_sitelibdir/sphinx/tests/

%description
Sphinx is a tool that makes it easy to create intelligent and beautiful
documentation for Python projects (or other documents consisting of
multiple reStructuredText sources)

%package devel
Summary: Development package for Sphinx
Group: Development/Python3
Requires: python3-module-%oname = %EVR
Requires: rpm-macros-sphinx3 = %EVR

%description devel
Sphinx is a tool that makes it easy to create intelligent and beautiful
documentation for Python projects (or other documents consisting of
multiple reStructuredText sources)

This package destinated for development of Python modules.

%package tests
Summary: Tests for Sphinx
Group: Development/Python3
Requires: python3-module-%oname = %EVR
%add_python3_req_skip compiler
%add_python3_req_skip missing_module missing_package1 missing_package2
%add_python3_req_skip missing_package3
%add_python3_req_skip dummy missing_package1.missing_module1 missing_package3.missing_module3
%add_python3_req_skip mod_resource mod_something sphinx.missing_module4 unknown

%description tests
Sphinx is a tool that makes it easy to create intelligent and beautiful
documentation for Python projects (or other documents consisting of
multiple reStructuredText sources)

This packages contains tests for Sphinx.

%if_enabled docs
%package doc
Summary: Documentation for Sphinx
Group: Development/Python3
%add_findreq_skiplist %sphinx3_dir/pickle/_downloads/example_google.py
%add_findreq_skiplist %sphinx3_dir/pickle/_downloads/example_numpy.py

%description doc
Sphinx is a tool that makes it easy to create intelligent and beautiful
documentation for Python projects (or other documents consisting of
multiple reStructuredText sources)

This package contains documentation for Sphinx itself.

%package pickles
Summary: Pickles for Sphinx
Group: Development/Python3

%description pickles
Sphinx is a tool that makes it easy to create intelligent and beautiful
documentation for Python projects (or other documents consisting of
multiple reStructuredText sources)

This packages contains pickles for Sphinx.
%endif

%package sphinx-build-symlink
Summary: Legacy sphinx3 to sphinx symlinks
Group: Development/Python3

%description sphinx-build-symlink
%summary

%package -n rpm-macros-sphinx3
Summary: RPM macros for build with Sphinx (Python 3)
Group: Development/Python3

# W.r.t. to the content of the macros (see the substitution in %%install):
#Requires: %sphinx3_dir
# ...but -- see the comment for rpm-macros-sphinx.

%description -n rpm-macros-sphinx3
Sphinx is a tool that makes it easy to create intelligent and beautiful
documentation for Python projects (or other documents consisting of
multiple reStructuredText sources)

This packages contains RPM macros for build with Sphinx.

%prep
%setup -n sphinx-%version
%autopatch -p1

install -pm644 %SOURCE1 .

ln -s %_datadir/python-sphinx/objects.inv doc/
ln -s %_datadir/python-sphinx/objects.inv tests/

cp %SOURCE3 sphinx/ext/
install -pm644 %SOURCE2 .

%build
%pyproject_build

%if_enabled docs
# docs
export PYTHONPATH=`pwd`
TERM="" make -C doc html
TERM="" make -C doc man
TERM="" make -C doc pickle
%endif

%install
%pyproject_install

cp -R tests %buildroot%sphinx3_dir/
for i in $(find %buildroot%sphinx3_dir/tests -type d)
do
	touch $i/__init__.py
done

ln -rs %buildroot%_datadir/python-sphinx/objects.inv \
	%buildroot%sphinx3_dir/
# There is some objects.inv there already; probably, we want to update it:
ln -frs %buildroot%_datadir/python-sphinx/objects.inv \
	%buildroot%sphinx3_dir/tests/

pushd %buildroot%_bindir
for i in $(ls); do
    mv $i py3_$i
    ln -s py3_$i $i
    ln -s py3_$i $i-3
    ln -s py3_$i $i-%__python3_version
done
popd

%if_enabled docs
# docs
install -d %buildroot%_docdir/%name
install -d %buildroot%_man1dir
cp -R doc/_build/html %buildroot%_docdir/%name/
install -p -m644 [A-Z]*.rst \
	%buildroot%_docdir/%name
%endif

# macros
install -d %buildroot%_rpmmacrosdir
sed -e 's:@SPHINX3_DIR@:%sphinx3_dir:g' < macro3 > %buildroot%_rpmmacrosdir/sphinx3

%if_enabled docs
install -d %buildroot%sphinx3_dir/doctrees
install -p -m644 doc/_build/doctrees/*.pickle \
	%buildroot%sphinx3_dir/doctrees/
cp -R doc/_build/pickle %buildroot%sphinx3_dir/
%endif

install -p -m644 conf.py.template \
	%buildroot%sphinx3_dir/

mkdir -p %buildroot%_rpmlibdir
cat <<\EOF >%buildroot%_rpmlibdir/python3-module-%oname-files.req.list
%sphinx3_dir	python3-module-%oname
EOF

%check
%pyproject_run_pytest --ignore tests/test_build_linkcheck.py

%files sphinx-build-symlink
%_bindir/*
%exclude %_bindir/*3*

%files
%_bindir/*3*
%sphinx3_dir/
%exclude %sphinx3_dir/tests
%exclude %sphinx3_dir/tests/test_builders
%exclude %sphinx3_dir/tests/test_extensions
%exclude %sphinx3_dir/tests/test_util
%exclude %sphinx3_dir/tests/utils.py
%exclude %sphinx3_dir/testing
%if_enabled docs
%exclude %sphinx3_dir/pickle
%exclude %sphinx3_dir/doctrees
%endif
%python3_sitelibdir/%oname-%version.dist-info/

%files devel
%files tests
%sphinx3_dir/tests
%sphinx3_dir/testing

%if_enabled docs
%files pickles
%sphinx3_dir/pickle
%sphinx3_dir/doctrees

%files doc
%doc %_docdir/%name
%endif

%files -n rpm-macros-sphinx3
%_rpmmacrosdir/sphinx3
%_rpmlibdir/python3-module-%oname-files.req.list

%changelog
