%define oname skosprovider

%def_with check

Name: python3-module-%oname
Version: 1.3.0
Release: alt1

Summary: Abstraction layer for SKOS vocabularies

License: MIT
Group: Development/Python3
Url: https://pypi.org/project/skosprovider/
Vcs: https://github.com/OnroerendErfgoed/skosprovider

Source: %name-%version.tar

BuildArch: noarch

BuildRequires(pre): rpm-build-python3
BuildRequires: python3-module-hatchling
BuildRequires: python3-module-hatch-fancy-pypi-readme
%if_with check
BuildRequires: python3-module-pytest
BuildRequires: python3-module-rfc3987
BuildRequires: python3-module-language-tags
BuildRequires: python3-module-html5lib
%endif

%description
This library helps abstract vocabularies (thesauri, controlled lists,
authority files). It depends heavily on the SKOS specification, but adds
elements of other specifications such as the ISO 25964 SKOS extension
where deemed useful.

%prep
%setup

%build
%pyproject_build

%install
%pyproject_install

%check
%pyproject_run_pytest -v

%files
%doc *.rst LICENSE
%python3_sitelibdir/%oname
%python3_sitelibdir/%oname-%version.dist-info

%changelog
