%define oname sip
%define pkg_version %(echo %version | sed 's/\\./,/g')

Name: python3-module-%oname
Version: 4.19.19
Release: alt9.3

Summary: Python bindings generator for C++ class libraries

License: PSF
Group: Development/Python3
URL: http://www.riverbankcomputing.com/software/sip/

# hg clone http://www.riverbankcomputing.com/hg/sip
#Source-url: https://pypi.io/packages/source/s/%oname/%oname-%version.tar.gz
#Source-url: https://prdownloads.sourceforge.net/pyqt/sip/sip-%version/sip-%version.tar.gz
# Source-url: https://www.riverbankcomputing.com/static/Downloads/sip/%version/sip-%version.tar.gz
Source: %oname-%version.tar

Patch: sip-4.19.25-pyframe_getback.patch
Patch1: reimplementation_of_newer_and_newer_group_functions.patch

%py3_provides %oname

BuildRequires(pre): rpm-build-python3 python3-devel
BuildRequires: flex gcc-c++
BuildRequires: python3-module-setuptools

%description
Generates Python bindings for C++ class libraries from a set of class
specification files.  Also includes a Python extension module needed by all
generated bindings.

%package -n python3-module-%oname-devel
Requires: python3-module-%oname = %version-%release
Summary: Header files for sip (Python 3)
Group: Development/Python3
Requires: python3-devel

%description -n python3-module-%oname-devel
Header files for sip (Python 3).

%prep
%setup -n %oname-%version
%patch -p1
%patch1 -p2
sed -i 's/distutils/setuptools/g' sipdistutils.py

# Hot fix for python3.13
sed -i 's/PyEval_CallObject/PyObject_CallObject/g' siplib/{qtlib.c,siplib.c}

%build
python3 configure.py --debug -d %python3_sitelibdir
sed -i \
	's|^\(CPPFLAGS.*\)|\1 -g -I%__python3_includedir|' \
	*/Makefile
sed -i \
	's|lpython%__python3_version|l:%(basename %__libpython3)|' \
	siplib/Makefile
%make_build

%install
%makeinstall_std

mv %buildroot%_bindir/sip %buildroot%_bindir/sip3
sed -i 's|%_datadir/sip|%_datadir/sip3|' \
	%buildroot%python3_sitelibdir/sipconfig.py
sed -i 's|%_bindir/sip|%_bindir/sip3|' \
	%buildroot%python3_sitelibdir/sipconfig.py

%files
%doc README NEWS
%_bindir/sip3
%python3_sitelibdir/*
%exclude %python3_sitelibdir/*.pyi
%exclude %python3_sitelibdir/sipconfig.*
%exclude %python3_sitelibdir/sipdistutils.*

%files -n python3-module-%oname-devel
# Here, we just use the same path as in the build system:
%__python3_includedir/*
%python3_sitelibdir/*.pyi
%python3_sitelibdir/sipconfig.*
%python3_sitelibdir/sipdistutils.*
#doc doc/*

%changelog
