%define mname sksparse
%define oname scikits.sparse

%def_with check

Name: python3-module-%oname
Version: 0.4.16
Release: alt1

Summary: Sparse matrix tools extending scipy.sparse, but with incompatible licenses
License: BSD-2-Clause
Group: Development/Python3
Url: https://pypi.org/project/scikit-sparse/
VCS: https://github.com/scikit-sparse/scikit-sparse.git

Source: %name-%version.tar

BuildRequires(pre): rpm-build-python3
BuildRequires: python3-module-setuptools
BuildRequires: python3-module-wheel
BuildRequires: python3-module-numpy
BuildRequires: python3-module-Cython
BuildRequires: libnumpy-py3-devel
BuildRequires: libsuitesparse-devel
BuildRequires: python3-module-sphinx
%if_with check
BuildRequires: python3-module-pytest
BuildRequires: python3-module-numpy-testing
BuildRequires: python3-module-scipy
%endif

%description
This is a home for sparse matrix code in Python that plays well with
scipy.sparse, but that is somehow unsuitable for inclusion in scipy
proper. Usually this will be because it is released under the GPL.

So far we have a wrapper for the CHOLMOD library for sparse cholesky
decomposition.

%package tests
Summary: Tests for %oname
Group: Development/Python3
Requires: %name = %EVR

%description tests
This is a home for sparse matrix code in Python that plays well with
scipy.sparse, but that is somehow unsuitable for inclusion in scipy
proper. Usually this will be because it is released under the GPL.

So far we have a wrapper for the CHOLMOD library for sparse cholesky
decomposition.

This package contains tests for %oname.

%package pickles
Summary: Pickles for %oname
Group: Development/Python3

%description pickles
This is a home for sparse matrix code in Python that plays well with
scipy.sparse, but that is somehow unsuitable for inclusion in scipy
proper. Usually this will be because it is released under the GPL.

So far we have a wrapper for the CHOLMOD library for sparse cholesky
decomposition.

This package contains pickles for %oname.

%prep
%setup

sed -i 's|sphinx-build|sphinx-build-3|' doc/Makefile

%build
%pyproject_build

%install
%pyproject_install

export PYTHONPATH=%buildroot%python3_sitelibdir
%make -C doc pickle
%make -C doc html

install -d %buildroot%python3_sitelibdir/%oname
cp -fR doc/_build/pickle %buildroot%python3_sitelibdir/%oname/

%ifnarch armh %ix86
%check
export PYTHONPATH=%buildroot%python3_sitelibdir
py.test-3 -ra --pyargs sksparse
%endif

%files
%doc LICENSE.txt README.md doc/_build/html
%python3_sitelibdir/%mname
%python3_sitelibdir/%{pyproject_distinfo scikit_sparse}
%exclude %python3_sitelibdir/%oname/pickle
%exclude %python3_sitelibdir/%mname/test*

%files tests
%python3_sitelibdir/%mname/test*

%files pickles
%dir %python3_sitelibdir/%oname
%python3_sitelibdir/%oname/pickle


%changelog
