%define oname routes

Name: python3-module-%oname
Version: 2.5.1
Release: alt1.3
Summary: Routing Recognition and Generation Tools
License: BSD
Group: Development/Python3
URL: https://pypi.org/project/Routes
VCS: https://github.com/bbangert/routes

Source: %oname-%version.tar.gz
BuildArch: noarch

Requires: python3-module-repoze.lru

BuildRequires(pre): rpm-build-python3
BuildRequires: python3-module-setuptools
BuildRequires: python3-module-wheel
BuildRequires: python3-module-six

%description
Routes is a Python re-implementation of the Rails routes system for
mapping URLs to application actions, and conversely to generate URLs.
Routes makes it easy to create pretty and concise URLs that are RESTful
with little effort.

Routes allows conditional matching based on domain, cookies, HTTP
method, or a custom function. Sub-domain support is built in. Routes
comes with an extensive unit test suite.

%package doc
Summary: Documentation for Routing Recognition and Generation Tools
Group: Development/Documentation
BuildArch: noarch

%description doc
Routes is a Python re-implementation of the Rails routes system for
mapping URLs to application actions, and conversely to generate URLs.
Routes makes it easy to create pretty and concise URLs that are RESTful
with little effort.

This package contains documentation for Routes.

%package pickles
Summary: Pickles for Routing Recognition and Generation Tools
Group: Development/Python3

%description pickles
Routes is a Python re-implementation of the Rails routes system for
mapping URLs to application actions, and conversely to generate URLs.
Routes makes it easy to create pretty and concise URLs that are RESTful
with little effort.

This package contains pickles for Routes.

%prep
%setup
# https://setuptools.readthedocs.io/en/latest/userguide/distribution.html#tagging-and-daily-build-or-snapshot-releases
sed -i \
    -e 's/^tag_build[ \t]*=.*/# &/' \
    -e 's/^tag_date[ \t]*=.*/# &/' \
setup.cfg

%build
%pyproject_build

%install
%pyproject_install

export PYTHONPATH=%buildroot%python3_sitelibdir
pushd docs

install -d %buildroot%_docdir/%name
popd

%files
%doc *.rst *.txt
%python3_sitelibdir/%oname
%python3_sitelibdir/%{pyproject_distinfo %oname}/

%files doc
%_docdir/%name

%changelog
