%define oname robotframework

%def_with check

Name: python3-module-%oname
Version: 7.3.2
Release: alt1

Summary: A generic test automation framework

License: Apache-2.0
Group: Development/Python3
URL: https://pypi.org/project/robotframework
VCS: https://github.com/robotframework/robotframework

Source: %name-%version.tar

BuildRequires(pre): rpm-build-python3
BuildRequires: python3-module-setuptools
BuildRequires: python3-module-wheel

%if_with check
BuildRequires: python3(jsonschema)

BuildRequires: python3(tox)
%endif

%py3_provides %oname

Conflicts: python-module-%oname
Obsoletes: python-module-%oname

BuildArch: noarch

%description
Robot Framework is a generic test automation framework for acceptance
testing and acceptance test-driven development (ATDD). It has
easy-to-use tabular test data syntax and it utilizes the keyword-driven
testing approach. Its testing capabilities can be extended by test
libraries implemented either with Python or Java, and users can create
new higher-level keywords from existing ones using the same syntax that
is used for creating test cases.

%prep
%setup

%build
%pyproject_build

%install
%pyproject_install

%check
cat > tox.ini <<'EOF'
[testenv]
commands =
    # unit tests
    python utest/run.py -v
EOF
%tox_check_pyproject

%files
%doc *.txt *.rst
%_bindir/libdoc
%_bindir/rebot
%_bindir/robot
%python3_sitelibdir/robot/
%python3_sitelibdir/%oname-%version.dist-info/

%changelog
