%define oname requests-kerberos
%def_with check

Name: python3-module-%oname
Version: 0.15.0
Release: alt1

Summary: A Kerberos authentication handler for python-requests

License: MIT
Group: Development/Python3
URL: https://pypi.org/project/requests-kerberos
VCS: https://github.com/requests/requests-kerberos

Source: %name-%version.tar

BuildRequires(pre): rpm-build-python3
BuildRequires: python3-module-kerberos
BuildRequires: python3-module-setuptools
BuildRequires: python3-module-wheel

%if_with check
BuildRequires: python3-module-mock
BuildRequires: python3-module-requests
BuildRequires: python3-module-pytest
BuildRequires: python3-module-pytest-mock
BuildRequires: python3-module-spnego
%endif

Requires: python3-module-requests >= 1.1
Requires: python3-module-kerberos

%add_python3_req_skip requests.packages.urllib3
%py3_provides %oname

BuildArch: noarch

%description
Requests is an HTTP library, written in Python, for human beings. This
library adds optional Kerberos/GSSAPI authentication support and
supports mutual authentication.

%prep
%setup

%build
%pyproject_build

%install
%pyproject_install

%check
%pyproject_run_pytest

%files
%doc AUTHORS README.rst HISTORY.rst LICENSE
%python3_sitelibdir/requests_kerberos
%python3_sitelibdir/requests_kerberos-%version.dist-info

%changelog
