%define oname pywebdav

%def_without check

Name:       python3-module-%oname
Version:    0.10.0
Release:    alt1
Summary:    PyWebDAV is a standards compliant WebDAV server and library written in Python

Group:      Development/Python3
License:    LGPLv2
URL:        https://github.com/andrewleech/PyWebDAV3
Source:     %name-%version.tar

BuildArch:  noarch

BuildRequires(pre): rpm-build-python3
BuildRequires: python3-module-pip
BuildRequires: python3-module-wheel
BuildRequires: python3-module-six

%description
WebDAV library for Python. WebDAV is an extension to the normal HTTP/1.1
protocol allowing the user to upload data, create collections of
objects, store properties for objects, etc.

%prep
%setup
# Upstream has problem with versioning
sed -i "s/__version__ = '0.9.14'/__version__ = '%version'/" pywebdav/__init__.py
# get rid of git-versioner
sed -i '/setup_requires/d' setup.py

%build
%python3_build

%install
%python3_install

%check
export PYTHONPATH=$PWD
python3 test/test_litmus.py

%files
%doc doc/*
%_bindir/davserver
%python3_sitelibdir/%oname
%python3_sitelibdir/PyWebDAV3-%version-py%_python3_version.egg-info


%changelog
