%define oname dotenv
%define pypi_name python-dotenv

%def_with check

Name: python3-module-%pypi_name
Version: 1.2.1
Release: alt1

Provides: python3-module-%oname = %EVR
Obsoletes: python3-module-%oname < 1.0.0-alt2

Summary: Reads the key-value pair from .env file and adds them to environment variable

License: BSD-3-Clause
Group: Development/Python
Url: https://github.com/theskumar/python-dotenv

Source: %name-%version.tar
Source1: %pyproject_deps_config_name
BuildArch: noarch

BuildRequires(pre): rpm-build-pyproject
%pyproject_builddeps_build
%pyproject_runtimedeps_metadata

%if_with check
BuildRequires: /dev/pts
BuildRequires: /proc
%pyproject_builddeps_metadata
%pyproject_builddeps_check
%endif

%description
Reads the key-value pair from .env file and adds them to environment
variable. It is great for managing app settings during development
and in production using 12-factor principles.

%prep
%setup -n %name-%version
%pyproject_deps_resync_build
%pyproject_deps_resync_metadata
%if_with check
%pyproject_deps_resync_check_tox tox.ini testenv
%endif

%build
# We don't support IPython for now (requires additional dependencies)
rm -f src/dotenv/ipython.py
%pyproject_build

%install
%pyproject_install

%check
# tests/test_docs.py:
# do not execute tests for docs
%pyproject_run_pytest -vra --deselect='tests/test_docs.py'

%files
%_bindir/%oname
%python3_sitelibdir/%oname/
%python3_sitelibdir/%{pyproject_distinfo %pypi_name}

%changelog
