%define _unpackaged_files_terminate_build 1
%define pypi_name pytest-randomly

%def_with check

Name: python3-module-%pypi_name
Version: 4.0.0
Release: alt1
Summary: Pytest plugin to randomly order tests and control random.seed
License: MIT
Group: Development/Python
Url: https://pypi.org/project/pytest-randomly/
Vcs: https://github.com/pytest-dev/pytest-randomly
BuildArch: noarch
Source: %name-%version.tar
Source1: %pyproject_deps_config_name
Patch: %name-%version-alt.patch
# manually manage runtime dependencies with metadata
AutoReq: yes, nopython3
%pyproject_runtimedeps_metadata
BuildRequires(pre): rpm-build-pyproject
%pyproject_builddeps_build

%if_with check
%pyproject_builddeps_metadata
%pyproject_builddeps_check
%endif

%description
Randomness in testing can be quite powerful to discover hidden flaws in the
tests themselves, as well as giving a little more coverage to your system.

By randomly ordering the tests, the risk of surprising inter-test dependencies
is reduced - a technique used in many places.

By resetting the random seed to a repeatable number for each test, tests can
create data based on random numbers and yet remain repeatable, for example
factory boy's fuzzy values. This is good for ensuring that tests specify the
data they need and that the tested system is not affected by any data that is
filled in randomly due to not being specified.

%prep
%setup
%patch -p1
%pyproject_deps_resync_build
%pyproject_deps_resync_metadata
%if_with check
%pyproject_deps_resync_check_depgroup test
%endif

%build
%pyproject_build

%install
%pyproject_install

%check
%pyproject_run_pytest -ra -p no:randomly tests

%files
%doc README.rst
%python3_sitelibdir/pytest_randomly/
%python3_sitelibdir/%{pyproject_distinfo %pypi_name}/

%changelog
