%define oname pyroute2

%def_with check

Name: python3-module-%oname
Version: 0.7.9
Release: alt1

Summary: Python Netlink library

Group: Development/Python3
License: GPLv2+ and Apache-2.0
Url: https://github.com/svinota/pyroute2

Source: %name-%version.tar

BuildArch: noarch

BuildRequires(pre): rpm-build-python3
BuildRequires: python3-module-setuptools
BuildRequires: python3-module-wheel
%if_with check
BuildRequires: python3-module-pytest
BuildRequires: python3-modules-sqlite3
%endif

%add_python3_req_skip pyroute2.bsd.rtmsocket
%add_python3_req_skip dhclient
%add_python3_req_skip netl
%add_python3_req_skip mitogen.core mitogen.master

%description
Pyroute2 is a pure Python3 netlink library.
It requires only Python stdlib, no 3rd party libraries.
The library was started as an RTNL protocol implementation,
so the name is pyroute2, but now it supports many netlink protocols.

%prep
%setup

%build
%pyproject_build

%install
%pyproject_install

%check
%pyproject_run_pytest -- tests/test_minimal/*.py tests/test_unit/*.py

%files
%doc *.rst
%_bindir/%oname-cli
%_bindir/%oname-dhcp-client
%_bindir/%oname-test-platform
%_bindir/ss2
%python3_sitelibdir/%oname
%python3_sitelibdir/pr2modules
%python3_sitelibdir/%oname-%version.dist-info

%changelog
