%define _unpackaged_files_terminate_build 1
%define pypi_name pyproject-installer
%define mod_name pyproject_installer

%define pyproject_installer export PYTHONPATH=$(pwd)/src; %__python3 -m %mod_name -v

%def_with check

Name: python3-module-%pypi_name
Version: 0.5.6
Release: alt1
Summary: Builder and installer of Python project
License: MIT
Group: Development/Python3
Url: https://pypi.org/project/pyproject-installer
VCS: https://github.com/stanislavlevin/pyproject_installer
BuildArch: noarch
Source: %name-%version.tar
Patch: %name-%version-alt.patch
# manually manage dependencies
AutoReq: yes, nopython3
%py3_provides %pypi_name
# hide vendored distributions
%add_findprov_skiplist %python3_sitelibdir/%mod_name/_vendor/*

BuildRequires(pre): rpm-build-python3

%if_with check
BuildRequires: python3(pytest)
BuildRequires: python3(pytest_mock)
%endif

%description
This tool is intended to build wheel from Python source tree and install it.

%prep
%setup
%autopatch -p1

%build
%pyproject_installer build

%install
%pyproject_installer install --destdir=%buildroot

%check
%pyproject_installer run -- pytest -vra tests/unit

%files
%doc README.md
%python3_sitelibdir/%mod_name/
%python3_sitelibdir/%{pyproject_distinfo %pypi_name}/

%changelog
