%define _unpackaged_files_terminate_build 1
%define pypi_name pyproject-fmt

%def_with check

Name: python3-module-%pypi_name
Version: 2.6.0
Release: alt1
Summary: Format pyproject.toml file
License: MIT
Group: Development/Python3
Url: https://pypi.org/project/pyproject-fmt
VCS: https://github.com/tox-dev/pyproject-fmt.git
Source: %name-%version.tar
Source1: %pyproject_deps_config_name
Source2: vendor_rust.tar
Patch: %name-%version-alt.patch

%pyproject_runtimedeps_metadata
BuildRequires(pre): rpm-build-pyproject
%pyproject_builddeps_build
%if_with check
%pyproject_builddeps_metadata
%pyproject_builddeps_check
%endif

%description
%summary.

%prep
%setup -a2
%autopatch -p1
mkdir .cargo
cat < vendor_cargoconf.toml >> .cargo/config.toml
%pyproject_scm_init
cd pyproject-fmt
%pyproject_deps_resync_build
%pyproject_deps_resync_metadata
%if_with check
%pyproject_deps_resync_check_depgroup test
%endif

%build
cd pyproject-fmt
%pyproject_build

%install
cd pyproject-fmt
%pyproject_install

%check
cd pyproject-fmt
%pyproject_run_pytest -ra tests

%files
%doc README.md
%_bindir/%pypi_name
%python3_sitelibdir/pyproject_fmt/
%python3_sitelibdir/%{pyproject_distinfo %pypi_name}/

%changelog
