%define modulename pypdf

# Relies on a lot of network
%def_without check

Name: python3-module-%modulename
Version: 6.1.1
Release: alt1

Summary: A Pure-Python library built as a PDF toolkit

Group: Development/Python3
License: BSD-3-Clause
URL: https://pypi.org/project/pypdf
VCS: https://github.com/py-pdf/pypdf

BuildArch: noarch
Source: %name-%version.tar

BuildArch: noarch

BuildRequires(pre): rpm-build-python3
BuildRequires: python3-module-flit

%description
A Pure-Python library built as a PDF toolkit.  It is capable of:

- extracting document information (title, author, ...),
- splitting documents page by page,
- merging documents page by page,
- cropping pages,
- merging multiple pages into a single page,
- encrypting and decrypting PDF files.

By being Pure-Python, it should run on any Python platform without any
dependencies on external libraries.  It can also work entirely on StringIO
objects rather than file streams, allowing for PDF manipulation in memory.
It is therefore a useful tool for websites that manage or manipulate PDFs.

%prep
%setup

%build
%pyproject_build

%install
%pyproject_install

%files
%doc LICENSE *.md
%python3_sitelibdir/%modulename
%python3_sitelibdir/%{pyproject_distinfo %modulename}

%changelog
