%define _unpackaged_files_terminate_build 1
%define oname pylbfgs

%def_with check

Name: python3-module-%oname
Version: 0.2.0.16
Release: alt1

Summary: LBFGS and OWL-QN optimization algorithms

License: MIT
Group: Development/Python3
Url: https://pypi.python.org/pypi/PyLBFGS

Source0: %name-%version.tar

BuildRequires(pre): rpm-build-python3
BuildRequires: python3-module-Cython
BuildRequires: libnumpy-py3-devel
%if_with check
BuildRequires: python3-module-pytest
BuildRequires: python3-module-pytest-cov
BuildRequires: python3-module-numpy-testing
%endif

%py3_provides %oname lbfgs
%py3_requires numpy

%description
This is a Python wrapper around Naoaki Okazaki (chokkan)'s liblbfgs
library of quasi-Newton optimization routines (limited memory BFGS and
OWL-QN).

This package aims to provide a cleaner interface to the LBFGS algorithm
than is currently available in SciPy, and to provide the OWL-QN
algorithm to Python users.

%prep
%setup

%build
%python3_build

%install
%python3_install

cp liblbfgs/README README.libLBFGS

%check
export PYTHONPATH=%buildroot%python3_sitelibdir
py.test-3 -v

%files
%doc *.rst README.libLBFGS
%python3_sitelibdir/*

%changelog
