%define oname pyglet

%def_disable docs

Name: python3-module-%oname
Version: 1.5.30
Release: alt1
Summary: Cross-platform windowing and multimedia library

Group: Development/Python3
License: BSD
URL: http://www.pyglet.org/
# hg clone https://bitbucket.org/pyglet/pyglet
Source: %oname-%version.tar.gz
BuildArch: noarch


%add_python3_req_skip Cocoa CoreFoundation LaunchServices Quartz
%filter_from_requires /darwin/d
%filter_from_requires /carbon/d
%filter_from_requires /win32/d

# Automatically added by buildreq on Thu Jan 02 2025
# optimized out: bash5 libgpg-error openssl-config python3 python3-base python3-dev python3-module-Pygments python3-module-alabaster python3-module-babel python3-module-charset-normalizer python3-module-jaraco.collections python3-module-jaraco.context python3-module-jaraco.functools python3-module-jaraco.text python3-module-jinja2 python3-module-more-itertools python3-module-packaging python3-module-pkg_resources python3-module-py3dephell python3-module-sphinx python3-module-wheel sh5
BuildRequires: python3-module-genshi python3-module-pyproject-installer python3-module-setuptools

%description
pyglet provides an object-oriented programming interface for developing
games and other visually-rich applications for Windows, Mac OS X and
Linux.

%if_enabled docs
BuildRequires(pre): rpm-build-python3
BuildRequires(pre): rpm-macros-sphinx3
BuildRequires: python3-module-html5lib python3-module-sphinx

%package pickles
Summary: Pickles for cross-platform windowing and multimedia library
Group: Development/Python

%description pickles
pyglet provides an object-oriented programming interface for developing
games and other visually-rich applications for Windows, Mac OS X and
Linux.

This package contains pickles for pyglet.

%package docs
Summary: Documentation for cross-platform windowing and multimedia library
Group: Development/Documentation
BuildArch: noarch

%description docs
pyglet provides an object-oriented programming interface for developing
games and other visually-rich applications for Windows, Mac OS X and
Linux.

This package contains development documentation for pyglet.

%endif

%prep
%setup

touch tools/__init__.py

%if_enabled docs
%prepare_sphinx .
%endif

%build
%pyproject_build

%install
%pyproject_install
pushd %buildroot%python3_sitelibdir/%oname
rm -fR */win32* libs/darwin input/*win* */*carbon.* \
	image/codecs/quicktime.* image/codecs/gdiplus.*
popd

%if_enabled docs
./make.py clean
mkdir -p doc/_build/html
./make.py docs

#generate_pickles $PWD $PWD/doc/_build/html %oname
%make -C doc pickle
install -d %buildroot%python_sitelibdir/%oname
cp -fR doc/_build/pickle %buildroot%python_sitelibdir/%oname/
%endif

%files
%doc DESIGN LICENSE NOTICE README.md
%python3_sitelibdir/*
%if_enabled docs
%exclude %python3_sitelibdir/%oname/pickle
%endif

%if_enabled docs
%files pickles
%dir %python3_sitelibdir/%oname
%python3_sitelibdir/%oname/pickle

%files docs
%doc doc/programming_guide doc/_build/html examples
%endif

%changelog
