%define oname pygame

%def_with check

Name: python3-module-pygame
Version: 2.6.1
Release: alt2.1

Summary: A Python module for interfacing with the SDL multimedia library
Summary(ru_RU.UTF-8): Расширение языка Python для работы с библиотекой SDL

Group: Development/Python3
License: LGPL-2.1
Url: https://pypi.org/project/pygame

Source: %name-%version.tar
Patch: pygame-2.1.0-docs.patch

%define python3_includedir %_includedir/python%_python3_version

BuildRequires(pre): rpm-build-python3

BuildRequires: libfreetype-devel
BuildRequires: libSDL2_image-devel libSDL2_mixer-devel libSDL2_ttf-devel
BuildRequires: libjpeg-devel libpng-devel libportmidi-devel
BuildRequires: python3-module-setuptools
BuildRequires: python3-module-wheel
BuildRequires: python3-module-Cython
BuildRequires: python3-module-sphinx

%if_with check
BuildRequires: python3-module-pytest
BuildRequires: python3-module-numpy
BuildRequires: libvorbis
BuildRequires: fonts-ttf-xorg
BuildRequires: fonts-ttf-dejavu
%endif

Requires: libSDL >= 1.2.7

%add_python3_req_skip AppKit Foundation py2app Numeric opencv

%description
pygame is a Python wrapper module for the SDL multimedia library, written by
Pete Shinners.  It contains python functions and classes that will allow you
to use SDL's support for playing cdroms, audio and video output, and keyboard,
mouse and joystick input. pygame also includes support for the Numerical
Python extension. pygame is the successor to the pySDL wrapper project, written
by Mark Baker.

Install %name if you would like to write or play SDL games written in the
python language.

%description -l ru_RU.UTF-8
pygame - расширение языка программирования Python, позволяющее
использовать возможности мультимедийной библиотеки SDL (Simple
DirectMedia Layer), предоставляющей низкоуровневый доступ к звуковым
устройствам, клавиатуре, манипулятору мышь и к буферу экрана на
множестве различных платформ.


%package devel
Summary: Pygame development headers (Python 3)
Group: Development/Python3
BuildArch: noarch
Requires: %name = %EVR

%description devel
pygame is a Python wrapper module for the SDL multimedia library, written by
Pete Shinners.  It contains python functions and classes that will allow you
to use SDL's support for playing cdroms, audio and video output, and keyboard,
mouse and joystick input. pygame also includes support for Numerical Python
extension. pygame is the successor to the pySDL wrapper project, written by
Mark Baker.

Install %name-devel if you need the c/c++ include files.

%package doc
Summary: Pygame documentation and example programs (Python3 version)
Group: Development/Python3
BuildArch: noarch

%description doc
Pygame documentation and example programs (Python3 version)

%prep
%setup
%patch -p1
# https://github.com/pygame/pygame/issues/4469
sed -i "s/distutils\.ccompiler\.spawn/distutils.spawn.spawn/" setup.py
sed -i '811a\ \ \ \ @unittest.skip("https://github.com/pygame/pygame/issues/4274")' test/mixer_test.py

%build
%ifarch %ix86
export CFLAGS="-msse3"
%endif
export PYGAME_DETECT_AVX2=1
%pyproject_build
python3 setup.py docs

%install
%pyproject_install
sed -i '/^pkg_dir =/s@pkg_dir = .*@pkg_dir = "%_defaultdocdir/python3-module-pygame-doc-%version"@' %buildroot%python3_sitelibdir/%oname/docs/__main__.py

%if_without check
# else remove in check section
rm -rv %buildroot%python3_sitelibdir/%oname/tests
%endif

%check
export SDL_VIDEODRIVER=dummy
export SDL_AUDIODRIVER=disk
export LANG=en_US.UTF-8
export PYTHONPATH=%buildroot%python3_sitelibdir
python3 -m pygame.tests -v --exclude opengl --time_out 300
# Clean up from tests
rm -rv %buildroot%python3_sitelibdir/%oname/tests

%files
%python3_sitelibdir/%oname
%python3_sitelibdir/%oname-%version.dist-info

%files doc
%doc docs/.

%files devel
%python3_includedir/%oname

%changelog
