%define oname pyeclib

%def_with check

Name:           python3-module-%oname
Version:        1.7.0
Release:        alt1

Summary:        Python interface to erasure codes

Group:          Development/Python3
License:        BSD
URL:            https://pypi.org/project/pyeclib

Source0:        %name-%version.tar

BuildRequires(pre): rpm-build-python3
BuildRequires:  python3-module-setuptools
BuildRequires:  python3-module-wheel
BuildRequires:  liberasurecode-devel >= 1.0.7
BuildRequires:  chrpath

%if_with check
BuildRequires:  python3-module-pytest
BuildRequires:  python3-module-six
%endif

Requires:       liberasurecode >= 1.0.7

%description
This library provides a simple Python interface for implementing erasure
codes. A number of back-end implementations is supported either directly
or through the C interface liberasurecode.

%prep
%setup

%build
%pyproject_build

%install
%pyproject_install

find "%buildroot%python3_sitelibdir" -name "pyeclib_c.*.so" | xargs chrpath -d

%check
%pyproject_run_pytest

%files
%doc README.rst
%_bindir/pyeclib-backend
%python3_sitelibdir/%oname
%python3_sitelibdir/pyeclib_c.abi3.so
%python3_sitelibdir/%oname-%version.dist-info

%changelog
