%define  modulename pydata-sphinx-theme

%def_with check

Name:    python3-module-%modulename
Version: 0.16.1
Release: alt2

Summary: Bootstrap-based sphinx theme from the PyData community

License: BSD-3-Clause
Group:   Development/Python3
URL:     https://pypi.org/project/pydata-sphinx-theme
VCS:     https://github.com/pydata/pydata-sphinx-theme

Packager: Grigory Ustinov <grenka@altlinux.org>

BuildRequires(pre): rpm-build-python3

BuildRequires: python3-module-wheel
BuildRequires: python3-module-sphinx-theme-builder
BuildRequires: python3-module-nodeenv
BuildRequires: yarn webpack npm
BuildRequires: /proc /dev/pts

%if_with check
BuildRequires: python3-module-pytest
BuildRequires: python3-module-sphinx
BuildRequires: python3-module-BeautifulSoup4
BuildRequires: python3-module-sphinx-tests
BuildRequires: python3-module-typing-extensions
BuildRequires: python3-module-pytest-regressions
BuildRequires: python3-module-accessible-pygments
%endif

BuildArch: noarch

Source:  %name-%version.tar

Patch: 2091.patch

%description
%summary.

%prep
%setup
%patch -p1

sed -i "s,^\(node-version = \)".*",\1\"$(node --version | sed 's/v//')\"," pyproject.toml

%build
export YARN_CACHE_FOLDER="$PWD/.package-cache"
yarn install --offline
python3 -m nodeenv --node=system --prebuilt --clean-src $PWD/.nodeenv

%pyproject_build

%install
%pyproject_install

%check
# Translation does not work correctly in an uninstalled tree
%pyproject_run_pytest -k 'not test_translations'

%files
%doc LICENSE *.md
%python3_sitelibdir/pydata_sphinx_theme
%python3_sitelibdir/pydata_sphinx_theme-%version.dist-info

%changelog
