%def_disable snapshot

# since 1.29.0
# Disable X11 surface support (Xlib and XCB) even if cairo has it enabled
%def_disable no_x11
%def_with doc
%def_enable check

%define modname cairo
%define oname py%modname
%define ver_major 1.29

Name: python3-module-%oname
Version: %ver_major.0
Release: alt1

Summary: Pycairo is a set of Python bindings for the cairo vector graphics library
Group: Development/Python3
License: LGPL-2.1 and MPL-1.1
Url: https://github.com/pygobject/pycairo

Vcs: https://github.com/pygobject/pycairo.git

%if_disabled snapshot
Source: %url/releases/download/v%version/%oname-%version.tar.gz
%else
Source: %oname-%version.tar
%def_with bootstrap
%endif

BuildRequires(pre): rpm-macros-meson rpm-build-python3 rpm-build-gir
BuildRequires: meson libcairo-devel >= 1.15.10 python3-devel
%{?_with_bootstrap:BuildRequires: python3-module-Pygments}
%{?_with_doc:
BuildRequires(pre): rpm-macros-sphinx3
BuildRequires: texlive-latex-base python3-module-sphinx-devel >= 6.1.3 python3-module-sphinx_rtd_theme}
%{?_enable_check:BuildRequires: python3-module-pytest}

%description
The Pycairo bindings are designed to match the cairo C API as closely as
possible, and to deviate only in cases which are clearly better implemented in
a more 'Pythonic' way.

%package devel
Summary: Development files for pycairo
Group: Development/Python3
Requires: %name = %EVR

%description devel
Development files for pycairo.

%package docs
Summary: Documentation for pycairo
Group: Development/Documentation
BuildArch: noarch

%description docs
Documentation for pycairo.

%package tests
Summary: Tests for pycairo
Group: Development/Python3
Requires: %name = %EVR

%description tests
Documentation for pycairo.

%package examples
Summary: Examples for pycairo
Group: Development/Python3
Requires: %name = %EVR
%add_python3_req_skip snippets

%description examples
Examples for pycairo.

%package pickles
Summary: Pickles for pycairo
Group: Development/Python3

%description pickles
Pickles for pycairo.

%prep
%setup -n %oname-%version
%{?_with_doc:%prepare_sphinx3 docs}

%build
%meson %{subst_enable_meson_bool no_x11 no-x11}
%nil
%meson_build
%{?_with_doc:%make_build -C docs}

%install
%meson_install

# docs
install -d %buildroot%_docdir/%name-%version
install -p -m644 NEWS README* \
    %buildroot%_docdir/%name-%version

%if_with doc
cp -fR docs/_build/reference %buildroot%_docdir/%name-%version/

# pickles
install -d %buildroot%python3_sitelibdir/%oname/pickle
cp -fR docs/_build/.doctrees/* %buildroot%python3_sitelibdir/%oname/pickle/

# tests and examples
cp -fR examples tests %buildroot%python3_sitelibdir/%modname/
for i in $(find %buildroot%python3_sitelibdir/%modname/examples -type d)
do
    touch $i/__init__.py
done

%pre pickles
rm -fR %python3_sitelibdir/%oname/pickle
%endif # doc

%check
%__meson_test

%files
%python3_sitelibdir/%modname/
%python3_sitelibdir/%oname-%version.dist-info
%if_with doc
%exclude %python3_sitelibdir/%modname/tests
%exclude %python3_sitelibdir/%modname/examples
%endif
%doc %dir %_docdir/%name-%version
%doc %_docdir/%name-%version/NEWS
%doc %_docdir/%name-%version/README*

%files devel
%dir %_includedir/%oname
%_includedir/%oname/py3cairo.h
%_pkgconfigdir/py3cairo.pc

%if_with doc
%files docs
%doc %dir %_docdir/%name-%version
%doc %_docdir/%name-%version
%exclude %_docdir/%name-%version/NEWS
%exclude %_docdir/%name-%version/README*

%files tests
%python3_sitelibdir/%modname/tests

%files examples
%python3_sitelibdir/%modname/examples

%files pickles
%dir %python3_sitelibdir/%oname
%python3_sitelibdir/%oname/pickle/
%endif

%changelog
