%define oname pybox2d

Name:           python3-module-%oname
Version:        2.3.2
Release:        alt2.1

Summary:        A 2D rigid body simulation library for Python
License:        zlib
Group:          Development/Python3
URL:            https://pypi.org/project/Box2D
VCS:            https://github.com/pybox2d/pybox2d

Source0:        https://github.com/pybox2d/%{oname}/archive/%{version}.tar.gz#/%{oname}-%{version}.tar.gz
Source44:       import.info

# Replace deprecated use of _swigconstant
# Upstream pull request: https://github.com/pybox2d/pybox2d/pull/90
Patch0:         replace-deprecated-swigconstant.patch

BuildRequires(pre): rpm-build-python3
BuildRequires:  gcc gcc-c++
BuildRequires:  swig

%{?python_provide:%python_provide python3-%{oname}}


%description
Programmer's can use Box2D in their games to make objects move in
believable ways and make the world seem more interactive. From the
game's point of view a physics engine is just a system for procedural
animation.

%prep
%setup -q -n %{oname}-%{version}
%patch0 -p1

sed -i 's|#!/usr/bin/env python|#!/usr/bin/env python3|' \
    $(find ./ -name '*.py')


%build
%python3_build

%install
%python3_install

%files
%doc --no-dereference LICENSE
%doc README.md examples/*
%{python3_sitelibdir}/*


%changelog
