%define oname pyasn

%def_with check

Name: python3-module-%oname
Version: 1.6.2
Release: alt1

Summary: Offline IP address to Autonomous System Number lookup module
License: MIT
Group: Development/Python3
Url: https://pypi.org/project/pyasn
Vcs: https://github.com/hadiasghari/pyasn.git

Source: %name-%version.tar

BuildRequires(pre): rpm-build-python3
BuildRequires: python3-module-setuptools
BuildRequires: python3-module-wheel
%if_with check
BuildRequires: python3-module-pytest
%endif

%py3_provides %oname

%description
pyasn is a Python extension module that enables very fast IP address to
Autonomous System Number lookups. Current state and Historical lookups
can be done, based on the BGP / MRT file used as input.

pyasn is different from other ASN lookup tools in that it providers
offline and historical lookups. It provides utility scripts for users to
build their own lookup databases based on any BGP/MRT dump file. This
makes pyasn much faster than online dig/whois/json lookups.

%prep
%setup

%build
%pyproject_build

%install
%pyproject_install

%check
export PYTHONPATH=%buildroot%python3_sitelibdir
py.test-3

%files
%doc README.*
%_bindir/*
%python3_sitelibdir/%oname
%python3_sitelibdir/%oname-%version.dist-info


%changelog
