%define oname psutil

# can't check not on a real system
%def_disable check

Name: python3-module-%oname
Version: 7.0.0
Release: alt1

Summary: A process utilities module for Python

License: BSD
Group: Development/Python3
Url: https://pypi.python.org/pypi/psutil/

# Source-url: %__pypi_url %oname
Source: %oname-%version.tar

%add_python3_req_skip _psutil_bsd _psutil_mswindows _psutil_osx pywintypes win32com
%add_python3_req_skip _psutil_sunos psutil._psutil_windows

BuildRequires(pre): rpm-build-intro >= 2.2.5
BuildRequires(pre): rpm-build-python3

%if_enabled check
BuildRequires: python3-module-pytest
BuildRequires: /proc /sys
%endif

%description
psutil is a module providing an interface for retrieving information on running
processes and system utilization (CPU, memory) in a portable way by using
Python, implementing many functionalities offered by tools like ps, top and
Windows task manager.

%prep
%setup -n %oname-%version

%build
%python3_build

%install
%python3_install
%python3_prune

%check
%if_enabled check
python3 setup.py build_ext -i
export PYTHONPATH=$PWD
py.test-3 -vv
%endif

%files
%doc CREDITS *.rst LICENSE docs/*.rst
%python3_sitelibdir/*

%changelog
