%set_python3_req_method strict
%define _unpackaged_files_terminate_build 1
%define pypi_name proxmoxer
%def_with check

Name: python3-module-%pypi_name
Version: 2.2.0
Release: alt1

Summary: A Python wrapper for Proxmox REST API
License: MIT
Group: Development/Python3
Url: https://pypi.org/project/proxmoxer
VCS: https://github.com/proxmoxer/proxmoxer
BuildArch: noarch

Source: %name-%version.tar

BuildRequires(pre): rpm-build-python3
BuildRequires: python3(setuptools)
BuildRequires: python3(wheel)
BuildRequires: python3(requests)
BuildRequires: python3(paramiko)

%if_with check
BuildRequires: python3(responses)
BuildRequires: python3(requests_toolbelt)
BuildRequires: python3(pytest)
BuildRequires: python3(openssh_wrapper)
%endif

%add_python3_req_skip httplib # python3(http) is used instead this
%add_python3_req_skip urlparse # python3(urllib) is used instead this

%description
Proxmoxer is a python wrapper around the Proxmox REST API v2.
It currently supports the Proxmox services of Proxmox Virtual Environment (PVE),
Proxmox Mail Gateway (PMG), and Proxmox Backup Server (PBS).

%prep
%setup

%build
%pyproject_build

%install
%pyproject_install

%check
%pyproject_run_pytest

%files
%python3_sitelibdir/%pypi_name
%python3_sitelibdir/%pypi_name-%version.dist-info
%doc README.rst LICENSE.txt

%changelog
