%define _unpackaged_files_terminate_build 1

%define oname prompt_toolkit

%def_with check

# sphinx_nefertiti theme is not packaged yet
%def_without doc

Name: python3-module-%oname
Version: 3.0.52
Release: alt1
Summary: Library for building powerful interactive command lines in Python
License: BSD-3-Clause
Group: Development/Python3
Url: https://pypi.org/project/prompt-toolkit
Vcs: https://github.com/prompt-toolkit/python-prompt-toolkit

BuildArch: noarch

Source: %name-%version.tar
Patch1: %oname-alt-docs.patch

%add_findreq_skiplist %python3_sitelibdir/%oname/eventloop/win32.py
%add_findreq_skiplist %python3_sitelibdir/%oname/input/win32.py

# mapping from PyPI name
# https://www.altlinux.org/Management_of_Python_dependencies_sources#Mapping_project_names_to_distro_names
Provides: python3-module-%{pep503_name %oname} = %EVR

BuildRequires(pre): rpm-build-python3
BuildRequires: python3-module-setuptools
BuildRequires: python3-module-wheel
%if_with doc
BuildRequires(pre): rpm-macros-sphinx3
BuildRequires: python3-module-sphinx
BuildRequires: python3-module-sphinx-sphinx-build-symlink
BuildRequires: python3-module-alabaster
BuildRequires: python3-module-docutils
BuildRequires: python3-module-objects.inv
BuildRequires: python3-module-sphinx-copybutton
%endif
%if_with check
BuildRequires: python3-module-pytest
BuildRequires: python3-module-wcwidth
%endif

%description
prompt_toolkit is a library for building powerful interactive command
lines in Python.

%package pickles
Summary: Pickles for %oname
Group: Development/Python3

%description pickles
prompt_toolkit is a library for building powerful interactive command
lines in Python.

This package contains pickles for %oname.

%package docs
Summary: Documentation for %oname
Group: Development/Documentation
BuildArch: noarch

%description docs
prompt_toolkit is a library for building powerful interactive command
lines in Python.

This package contains documentation for %oname.

%prep
%setup
%patch1 -p1

%if_with doc
%prepare_sphinx3 .
ln -s ../objects.inv docs/
%endif

%build
%pyproject_build

%install
%pyproject_install

%if_with doc
export PYTHONPATH=%buildroot%python3_sitelibdir
%make -C docs pickle
%make -C docs html
cp -fR docs/_build/pickle %buildroot%python3_sitelibdir/%oname/
%endif

%check
%pyproject_run_pytest -v

%files
%doc CHANGELOG *.rst LICENSE
%python3_sitelibdir/%oname
%python3_sitelibdir/%oname-%version.dist-info
%if_with doc
%exclude %python3_sitelibdir/%oname/pickle

%files pickles
%dir %python3_sitelibdir/%oname
%python3_sitelibdir/%oname/pickle

%files docs
%doc examples docs/_build/html
%endif

%changelog
