%define  modulename prometheus-pve-exporter
%def_without check

Name:    python3-module-%modulename
Version: 3.5.5
Release: alt2

Summary: Prometheus Proxmox VE Exporter
License: Apache-2.0
Group:   Development/Python
URL:     https://github.com/prometheus-pve/prometheus-pve-exporter.git

BuildArch: noarch

Source: %modulename-%version.tar
Source1: %modulename.service

Provides: %modulename = %EVR

BuildRequires(pre): rpm-build-python3
BuildRequires: python3(setuptools)
BuildRequires: python3(wheel)
BuildRequires: rpm-build-systemd
%if_with check
BuildRequires: python3(pyflakes)
BuildRequires: python3(pylint)
%endif

%description
This is an exporter that exposes information gathered from Proxmox VE node
for use by the Prometheus monitoring system.

%prep
%setup -n %modulename-%version

%build
%pyproject_build

%install
%pyproject_install
install -pDm0644 pve.yml %buildroot%_sysconfdir/prometheus/pve.yml
install -pDm0644 %SOURCE1 %buildroot%_unitdir/%modulename.service

%pre
groupadd -r -f prometheus 2>/dev/null ||:
useradd -r -g prometheus -c 'Prometheus PVE exporter user' \
        -d /var/lib/prometheus prometheus 2>/dev/null ||:

%post
%systemd_user_post %modulename.service

%preun
%systemd_user_preun %modulename.service

%postun
%systemd_user_postun %modulename.service

%check
#%%tox_create_default_config
%tox_check_pyproject

%files
%doc README.rst
%config(noreplace) %_sysconfdir/prometheus/pve.yml
%_unitdir/*
%_bindir/*
%python3_sitelibdir/*

%changelog
