%define oname python-poppler-qt5
%def_without check

Name: python3-module-poppler-qt5
Version: 21.3.0
Release: alt1.1

Summary: A Python binding to Poppler-Qt5

License: LGPLv2.1+
Group: Development/Python3
Url: https://pypi.python.org/pypi/python-poppler-qt5/

# Source-url: %__pypi_url %oname
Packager: Vitaly Lipatov <lav@altlinux.ru>

Source: %name-%version.tar

BuildRequires(pre): rpm-build-intro >= 2.2.5
BuildRequires(pre): rpm-build-python3

BuildRequires: gcc-c++ qt5-base-devel libpoppler-qt5-devel
BuildRequires: python3-devel python3-module-setuptools
BuildRequires: python3-module-sip6 python3-module-PyQt5-devel python3-module-PyQt-builder

%description
A Python binding for libpoppler-qt5 that aims for completeness and for
being actively maintained.

%prep
%setup

%build
%ifarch %e2k
# new poppler uses std::optional, so at least C++17 is required
%add_optflags -std=c++17
%endif
export PATH=$PATH:%_qt5_bindir
sip-build --verbose --no-make \
  --qmake-setting 'QMAKE_CFLAGS_RELEASE="%optflags"' \
  --qmake-setting 'QMAKE_CXXFLAGS_RELEASE="%optflags"' \
  --qmake-setting 'QMAKE_LFLAGS_RELEASE="%{?__global_ldflags}"'
%make_build -C build

%install
export PATH=$PATH:%_qt5_bindir
%makeinstall_std INSTALL_ROOT=%buildroot -C build
chmod +x %buildroot/%python3_sitelibdir/*.so

%check
%__python3 setup.py test

%files
%doc ChangeLog TODO *.rst
%python3_sitelibdir/popplerqt5*.so
%python3_sitelibdir/python_poppler*
%dir %python3_sitelibdir/PyQt5/bindings/
%python3_sitelibdir/PyQt5/bindings/popplerqt5/

%changelog
