%def_with check
# No module autoapi
%def_without docs

%define tomli %(%__python3 -c 'import sys;print(int(sys.version_info < (3, 11)))')

Name: python3-module-pikepdf
Version: 9.9.0
Release: alt1
License: MPL-2.0
Summary: A Python library for reading and writing PDF files
Group: Development/Python

Url: https://github.com/pikepdf/pikepdf
Source: %name-%version.tar

Requires: libpoppler-gir

BuildRequires: gcc-c++ libqpdf-devel jbig2dec

BuildRequires(pre): rpm-build-python3

# build backend and its deps
BuildRequires: python3(setuptools)
BuildRequires: python3(wheel)
BuildRequires: python3(setuptools-scm)
BuildRequires: python3(pybind11)
BuildRequires: python3(lxml)

%if_with docs
BuildRequires: ctags python3-module-sphinx-issues python3-module-sphinx_design python3-module-sphinx_rtd_theme python3-module-sphinxcontrib python3-module-sphinxcontrib-applehelp python3-module-sphinxcontrib-devhelp python3-module-sphinxcontrib-htmlhelp python3-module-sphinxcontrib-qthelp python3-module-sphinxcontrib-serializinghtml python3-module-Pillow
%endif

%if_with check
# deps
BuildRequires: python3(PIL)
BuildRequires: python3(packaging)

BuildRequires: python3(pytest)
BuildRequires: python3(hypothesis)
BuildRequires: python3(psutil)
BuildRequires: /proc
%if %tomli
BuildRequires: python3(tomli)
%endif
%endif

%description
pikepdf is based on QPDF, a powerful PDF manipulation and repair library.
Python + QPDF = "py" + "qpdf" = "pyqpdf", which looks like a dyslexia test.
Say it out loud, and it sounds like "pikepdf".

%prep
%setup
# disable pytest-xdist (unstable results)
sed -i 's/-n auto//' pyproject.toml

sed -i 's/license = "MPL-2.0"/license = {file = "LICENSE.txt"}/' pyproject.toml

# XXX don't want IPython as dependency
sed -i '/autodoc_mock_imports/s/\]/, "IPython"]/
/IPython.sphinxext/d
' docs/conf.py

# extra dependency, that not used in code
sed -i 's@"Deprecated", @@' pyproject.toml

%build
%pyproject_build

%install
%pyproject_install
%if_with docs
# docs build requires built C extension, but we can't control the path of build
# artifacts
PYTHONPATH="%buildroot%python3_sitelibdir" make SPHINXBUILD=sphinx-build-3 \
    -C docs html
%endif

%check
%ifarch armh
%define pytest_opts -k 'not test_build_instructions'
%endif
%tox_create_default_config
%tox_check_pyproject -- -vra %{?pytest_opts}

%files
%if_with docs
%doc docs/_build/html
%endif
%doc *.md
%python3_sitelibdir/pikepdf/
%python3_sitelibdir/%{pyproject_distinfo pikepdf}/

%changelog
