%define oname pg8000

%def_with check

Name: python3-module-%oname
Version: 1.31.5
Release: alt1

Summary: PostgreSQL interface library
License: BSD-3-Clause
Group: Development/Python3
Url: https://pypi.python.org/pypi/pg8000/
Vcs: https://codeberg.org/tlocke/pg8000

Source: %name-%version.tar

BuildArch: noarch

BuildRequires(pre): rpm-build-python3
BuildRequires: python3-module-hatchling
%if_with check
BuildRequires: python3-module-scramp
BuildRequires: python3-module-pytz
BuildRequires: python3-module-pytest
BuildRequires: python3-module-dateutil
%endif

%py3_provides %oname

%description
pg8000 is a pure-Python PostgreSQL driver that complies with DB-API 2.0.
It is tested on Python versions 3.7+, on CPython and PyPy, and PostgreSQL
versions 10+. pg8000's name comes from the belief that it is probably about
the 8000th PostgreSQL interface for Python. pg8000 is distributed under the
BSD 3-clause license.

%prep
%setup

# Fix version
sed -i '/dynamic = /d' pyproject.toml
sed -i '9a version = "%version"' pyproject.toml

%build
%pyproject_build

%install
%pyproject_install

# Most of tests need access to database
%check
%pyproject_run_pytest -v -k 'test_converters'

%files
%doc README.*
%python3_sitelibdir/%oname
%python3_sitelibdir/%{pyproject_distinfo %oname}


%changelog
