%define _unpackaged_files_terminate_build 1
%define oname persistent

%def_with check
%def_with docs

Name: python3-module-%oname
Version: 6.5
Release: alt1

Summary: Translucent persistent objects
License: ZPL-2.1
Group: Development/Python3
Url: https://pypi.org/project/persistent/
Vcs: https://github.com/zopefoundation/persistent.git

Source: %name-%version.tar

BuildRequires(pre): rpm-build-python3
BuildRequires: python3-module-setuptools
BuildRequires: python3-module-wheel
%if_with docs
BuildRequires(pre): rpm-macros-sphinx3
BuildRequires: python3-module-objects.inv
BuildRequires: python3-module-repoze.sphinx.autointerface
BuildRequires: python3-module-furo
BuildRequires: python3-module-sphinx_basic_ng
%endif
%if_with check
BuildRequires: python3-module-zope.testrunner
BuildRequires: python3-module-manuel
BuildRequires: python3-module-manuel-tests
BuildRequires: python3-module-cffi
BuildRequires: python3-module-zope.deferredimport
%endif

%py3_provides persistent.TimeStamp

%description
This package contains a generic persistence implementation for Python.
It forms the core protocol for making objects interact "transparently"
with a database such as the ZODB.

%package docs
Summary: Documentation for translucent persistent objects
Group: Development/Documentation
BuildArch: noarch

%description docs
This package contains documentation for persistence implementation for
Python. It forms the core protocol for making objects interact
"transparently" with a database such as the ZODB.

%package tests
Summary: Tests for translucent persistent objects
Group: Development/Python3
Requires: %name = %EVR

%description tests
This package contains a generic tests persistence implementation for
Python. It forms the core protocol for making objects interact
"transparently" with a database such as the ZODB.

%package devel
Summary: Development files for translucent persistent objects
Group: Development/Python3
Requires: %name = %EVR
Requires: python3-dev

%description devel
This package contains the files needed for binding the persistent C module.

%prep
%setup

%if_with docs
sed -i 's|sphinx-build|py3_sphinx-build|' docs/Makefile
%prepare_sphinx3 .
ln -s ../objects.inv3 docs/
%endif

%build
%add_optflags -fno-strict-aliasing
%pyproject_build

%install
%pyproject_install
install -p -m644 src/persistent/_compat.h \
	%buildroot%_includedir/python%_python3_version%_python3_abiflags/

# Don't bother with development files
rm %buildroot%python3_sitelibdir/%oname/*.c

%if_with docs
# Build documentation
export PYTHONPATH=%buildroot%python3_sitelibdir
%make -C docs html
rm -f docs/_build/html/.buildinfo
%endif

%check
%pyproject_run -- zope-testrunner --test-path=src -vc

%files
%doc *.txt README.rst CHANGES.rst
%python3_sitelibdir/%oname/
%python3_sitelibdir/%{pyproject_distinfo %oname}
%exclude %python3_sitelibdir/%oname/test*
%exclude %python3_sitelibdir/%oname/*.h

%if_with docs
%files docs
%doc docs/_build/html/*
%endif

%files tests
%python3_sitelibdir/%oname/test*

%files devel
%_includedir/python%_python3_version%_python3_abiflags
%python3_sitelibdir/%oname/*.h

%changelog
