%define _unpackaged_files_terminate_build 1
%define pypi_name pelican

%def_without docs
%def_with check

Name: python3-module-%pypi_name
Version: 4.11.0
Release: alt2
Summary: Static site generator that supports Markdown and reST syntax
License: AGPL-3.0
Group: Development/Python3
Url: http://getpelican.com/
Vcs: https://github.com/getpelican/pelican
BuildArch: noarch
Source: %pypi_name-%version.tar

Requires: python3-module-beautifulsoup4
Requires: python3-module-markdown
Requires: python3-module-unidecode
Requires: python3-module-blinker
Requires: python3-module-jinja2
Requires: python3-module-Pygments
Requires: python3-module-docutils
Requires: python3-module-feedgenerator
Requires: python3-module-pytz
Requires: python3-module-rich
Requires: python3-module-dateutil

BuildRequires(pre): rpm-build-python3
BuildRequires: python3-module-pdm-backend
%if_with docs
BuildRequires: python3-module-sphinx
BuildRequires: python3-module-sphinxext-opengraph
BuildRequires: python3-module-livereload
BuildRequires: python3-module-furo
%endif
%if_with check
BuildRequires: python3-module-pytest
BuildRequires: python3-module-rich
BuildRequires: python3-module-jinja2
BuildRequires: python3-module-dateutil
BuildRequires: python3-module-pytz
BuildRequires: python3-module-blinker
BuildRequires: python3-module-feedgenerator
BuildRequires: python3-module-docutils
BuildRequires: python3-module-unidecode
BuildRequires: python3-module-typogrify
BuildRequires: /usr/bin/git
BuildRequires: python3-module-beautifulsoup4
BuildRequires: python3-module-lxml
BuildRequires: python3-module-markdown
BuildRequires: python3-module-pytest-xdist
BuildRequires: python3-module-watchfiles
BuildRequires: python3-module-ordered-set
%endif

Obsoletes: python-module-%pypi_name
Conflicts: python-module-%pypi_name

%add_python3_req_skip pelican.plugins

%description
Pelican is a static site generator, written in Python.
- Compose content in Markdown or reStructuredText using your editor of choice
- Simple command-line tool (re)generates HTML, CSS, and JS from your source content
- Easy to interface with version control systems and web hooks
- Completely static output is simple to host anywhere

%package -n %pypi_name
Summary: %summary
Group: Publishing
Requires: %name = %EVR
Requires: python3-module-markdown
Requires: python3-module-unidecode
Requires: python3-module-beautifulsoup4

%description -n %pypi_name
Pelican is a static site generator, written in Python.
- Compose content in Markdown or reStructuredText using your editor of choice
- Simple command-line tool (re)generates HTML, CSS, and JS from your source content
- Easy to interface with version control systems and web hooks
- Completely static output is simple to host anywhere

%package tests
Summary: Tests for %name
Group: Development/Python3
Requires: %name = %EVR

%description tests
Pelican is a static site generator, written in Python.
- Compose content in Markdown or reStructuredText using your editor of choice
- Simple command-line tool (re)generates HTML, CSS, and JS from your source content
- Easy to interface with version control systems and web hooks
- Completely static output is simple to host anywhere

This package contains tests for %pypi_name.

%add_python3_req_skip pelican.tests.dummy_plugins.normal_plugin

%prep
%setup -n %pypi_name-%version

%build
%pyproject_build

%if_with docs
# Build docs (can't be exec without python3-module-pelican itself!)
export PYTHONPATH=$PWD
sphinx-build-3 docs html
# Remove leftovers from sphinxbuild
rm html/_static/theme-basic.zip
rm -rf html/_downloads/* html/.doctrees html/.buildinfo
%endif

%install
%pyproject_install

%check
# https://github.com/getpelican/pelican/issues/2846
%pyproject_run_pytest -v -W ignore::DeprecationWarning -n auto -k "\
not test_basic_generation_works \
and not test_custom_generation_works \
and not test_custom_locale_generation_works"

%files
%if_with docs
%doc html
%endif
%doc README.rst LICENSE
%_bindir/%pypi_name
%_bindir/pelican-import
%_bindir/pelican-plugins
%_bindir/pelican-quickstart
%_bindir/pelican-themes
%python3_sitelibdir/%pypi_name
%python3_sitelibdir/%{pyproject_distinfo %pypi_name}
%exclude %python3_sitelibdir/%pypi_name/tests

%files tests
%python3_sitelibdir/%pypi_name/tests

%files -n %pypi_name

%changelog
