%define oname oslo.versionedobjects
%def_with check
%def_with docs

Name: python3-module-%oname
Version: 3.8.0
Release: alt1

Summary: OpenStack Oslo Versioned Objects library

License: Apache-2.0
Group: Development/Python3
Url: https://pypi.org/project/oslo.versionedobjects

Source: %oname-%version.tar
Source1: %oname.watch

BuildArch: noarch

Provides: python3-module-oslo-versionedobjects = %EVR

BuildRequires(pre): rpm-build-python3
BuildRequires: python3-module-setuptools
BuildRequires: python3-module-wheel
BuildRequires: python3-module-oslo.concurrency >= 3.26.0
BuildRequires: python3-module-oslo.config >= 5.2.0
BuildRequires: python3-module-oslo.context >= 2.19.2
BuildRequires: python3-module-oslo.messaging >= 5.29.0
BuildRequires: python3-module-oslo.serialization >= 2.18.0
BuildRequires: python3-module-oslo.utils >= 7.4.0
BuildRequires: python3-module-oslo.log >= 3.36.0
BuildRequires: python3-module-oslo.i18n >= 3.15.3
BuildRequires: python3-module-webob >= 1.7.1
BuildRequires: python3-module-netaddr >= 0.7.18

%if_with check
BuildRequires: python3-module-hacking >= 6.1.0
BuildRequires: python3-module-testtools >= 2.2.0
BuildRequires: python3-module-coverage >= 4.0
BuildRequires: python3-module-jsonschema >= 3.2.0
BuildRequires: python3-module-stestr >= 2.0.0
BuildRequires: python3-module-fixtures >= 3.0.0
BuildRequires: python3-module-oslotest >= 3.2.0
%endif

%if_with docs
BuildRequires: python3-module-sphinx >= 2.0.0
BuildRequires: python3-module-openstackdocstheme >= 1.18.1
%endif

# for python w/o distutils
%filter_from_requires /python3(distutils.*)/d
Requires: python3(setuptools._distutils)

%description
The oslo.versionedobjects library provides a generic versioned object model
that is RPC-friendly, with inbuilt serialization, field typing, and remotable
method calls. It can be used to define a data model within a project independent
of external APIs or database schema for the purposes of providing upgrade
compatibility across distributed services.

%package tests
Summary: Tests for %oname
Group: Development/Python3
Requires: %name = %EVR

%description tests
This package contains tests for %oname.

%if_with docs
%package doc
Summary: Documentation for %oname
Group: Development/Documentation
Provides: python3-module-oslo-versionedobjects-doc = %EVR

%description doc
This package contains documentation for %oname.
%endif

%prep
%setup -n %oname-%version

# Remove bundled egg-info
rm -rfv *.egg-info

%build
%pyproject_build

%if_with docs
export PYTHONPATH="$PWD"
# generate html docs
sphinx-build-3 doc/source html
# generate man page
sphinx-build-3 -b man doc/source man
# remove the sphinx-build leftovers
rm -rf html/.{doctrees,buildinfo}
%endif

%install
%pyproject_install

%if_with docs
# install man page
install -pDm 644 man/osloversionedobjects.1 %buildroot%_man1dir/osloversionedobjects.1
%endif

%check
%__python3 -m stestr run

%files
%doc LICENSE AUTHORS ChangeLog *.rst
%python3_sitelibdir/oslo_versionedobjects
%python3_sitelibdir/%{pyproject_distinfo %oname}/
%exclude %python3_sitelibdir/oslo_versionedobjects/tests
%exclude %python3_sitelibdir/oslo_versionedobjects/test.py

%files tests
%python3_sitelibdir/oslo_versionedobjects/tests
%python3_sitelibdir/oslo_versionedobjects/test.py

%if_with docs
%files doc
%doc LICENSE *.rst html
%_man1dir/osloversionedobjects.1.xz
%endif

%changelog
