%define oname oslo.policy
%def_with check
%def_with docs

Name: python3-module-%oname
Version: 4.6.0
Release: alt1

Summary: OpenStack Oslo Policy library

License: Apache-2.0
Group: Development/Python3
Url: https://pypi.org/project/oslo.policy

Source: %oname-%version.tar
Source1: %oname.watch

BuildArch: noarch

Provides: python3-module-oslo-policy = %EVR

BuildRequires(pre): rpm-build-python3
BuildRequires: python3-module-setuptools
BuildRequires: python3-module-wheel
BuildRequires: python3-module-requests >= 2.14.2
BuildRequires: python3-module-oslo.config >= 6.0.0
BuildRequires: python3-module-oslo.context >= 2.22.0
BuildRequires: python3-module-oslo.i18n >= 3.15.3
BuildRequires: python3-module-oslo.serialization >= 2.18.0
BuildRequires: python3-module-stevedore >= 1.20.0
BuildRequires: python3-module-oslo.utils >= 3.40.0
BuildRequires: python3-module-yaml >= 3.12

%if_with check
BuildRequires: python3-module-oslotest >= 3.2.0
BuildRequires: python3-module-stestr >= 2.0.0
BuildRequires: python3-module-sphinx >= 2.0.0
BuildRequires: python3-module-coverage >= 4.0
BuildRequires: python3-module-requests-mock >= 1.2.0
%endif

%if_with docs
BuildRequires: python3-module-sphinx >= 2.0.0
BuildRequires: python3-module-openstackdocstheme
BuildRequires: python3-module-sphinxcontrib-apidoc
%endif

%description
The Oslo Policy library provides support for RBAC policy enforcement across all
OpenStack services.

%package tests
Summary: Tests for %oname
Group: Development/Python3
Requires: %name = %EVR

%description tests
This package contains tests for %oname.

%if_with docs
%package doc
Summary: Documentation for %oname
Group: Development/Documentation
Provides: python3-module-oslo-policy-doc = %EVR

%description doc
This package contains documentation for %oname.
%endif

%prep
%setup -n %oname-%version

# Remove bundled egg-info
rm -rfv *.egg-info

%build
%pyproject_build

%if_with docs
export PYTHONPATH="$PWD"
# generate html docs
sphinx-build-3 doc/source html
# generate man page
sphinx-build-3 -b man doc/source man
# remove the sphinx-build leftovers
rm -rf html/.{doctrees,buildinfo}
%endif

%install
%pyproject_install

%if_with docs
# install man page
install -pDm 644 man/oslopolicy-checker.1 %buildroot%_man1dir/oslopolicy-checker.1
install -pDm 644 man/oslopolicy-list-redundant.1 %buildroot%_man1dir/oslopolicy-list-redundant.1
install -pDm 644 man/oslopolicy-policy-generator.1 %buildroot%_man1dir/oslopolicy-policy-generator.1
install -pDm 644 man/oslopolicy-sample-generator.1 %buildroot%_man1dir/oslopolicy-sample-generator.1
%endif

%check
%__python3 -m stestr run

%files
%doc LICENSE AUTHORS ChangeLog *.rst
%_bindir/oslopolicy-checker
%_bindir/oslopolicy-convert-json-to-yaml
%_bindir/oslopolicy-list-redundant
%_bindir/oslopolicy-policy-generator
%_bindir/oslopolicy-policy-upgrade
%_bindir/oslopolicy-sample-generator
%_bindir/oslopolicy-validator
%python3_sitelibdir/oslo_policy
%python3_sitelibdir/%{pyproject_distinfo %oname}/
%exclude %python3_sitelibdir/oslo_policy/tests

%files tests
%python3_sitelibdir/oslo_policy/tests

%if_with docs
%files doc
%doc LICENSE *.rst html
%_man1dir/oslopolicy-checker.1.xz
%_man1dir/oslopolicy-list-redundant.1.xz
%_man1dir/oslopolicy-policy-generator.1.xz
%_man1dir/oslopolicy-sample-generator.1.xz
%endif

%changelog
