%define oname oslo.config
%def_with check
%def_with docs

Name: python3-module-%oname
Version: 10.0.0
Release: alt1

Summary: OpenStack Oslo Configuration API

License: Apache-2.0
Group: Development/Python3
Url: https://pypi.org/project/oslo.config

Source: %oname-%version.tar
Source1: %oname.watch

BuildArch: noarch

Provides: python3-module-oslo-config = %EVR
%py3_provides oslo

BuildRequires(pre): rpm-build-python3
BuildRequires: python3-module-setuptools
BuildRequires: python3-module-wheel
BuildRequires: python3-module-pbr
BuildRequires: python3-module-netaddr >= 0.7.18
BuildRequires: python3-module-stevedore >= 1.20.0
BuildRequires: python3-module-oslo.i18n >= 3.15.3
BuildRequires: python3-module-rfc3986 >= 1.2.0
BuildRequires: python3-module-requests >= 2.18.0

%if_with check
BuildRequires: python3-module-fixtures >= 3.0.0
BuildRequires: python3-module-mock >= 2.0
BuildRequires: python3-module-stestr >= 2.1.0
BuildRequires: python3-module-oslotest >= 3.2.0
BuildRequires: python3-module-oslo.log >= 3.36.0
BuildRequires: python3-module-hacking >= 6.1.0
BuildRequires: python3-module-testscenarios >= 0.4
BuildRequires: python3-module-testtools >= 2.2.0
BuildRequires: python3-module-mypy >= 0.720
BuildRequires: python3-module-coverage >= 4.0
BuildRequires: python3-module-requests-mock
%endif

%if_with docs
BuildRequires: python3-module-sphinx >= 1.2.1
BuildRequires: python3-module-openstackdocstheme
BuildRequires: python3-module-sphinxcontrib-apidoc
BuildRequires: python3-module-yaml
%endif

%description
The Oslo project intends to produce a python library containing
infrastructure code shared by OpenStack projects. The APIs provided
by the project should be high quality, stable, consistent and generally
useful.

The oslo-config library is a command line and configuration file
parsing library from the Oslo project.

%package tests
Summary: Tests for %oname
Group: Development/Python3
Requires: %name = %EVR

%description tests
This package contains tests for %oname.

%if_with docs
%package doc
Summary: Documentation for %oname
Group: Development/Documentation
Provides: python3-module-oslo-config-doc = %EVR

%description doc
This package contains documentation for %oname.
%endif

%prep
%setup -n %oname-%version

# Remove bundled egg-info
rm -rfv *.egg-info

%build
%pyproject_build

%if_with docs
export PYTHONPATH="$PWD"
# generate html docs
sphinx-build-3 doc/source html
# generate man page
sphinx-build-3 -b man doc/source man
# remove the sphinx-build leftovers
rm -rf html/.{doctrees,buildinfo}
%endif

%install
%pyproject_install

%if_with docs
# install man page
install -pDm 644 man/osloconfig.1 %buildroot%_man1dir/osloconfig.1
%endif

%check
%__python3 -m stestr run

%files
%doc LICENSE AUTHORS ChangeLog *.rst
%_bindir/oslo-config-generator
%_bindir/oslo-config-validator
%python3_sitelibdir/oslo_config
%python3_sitelibdir/%{pyproject_distinfo %oname}/
%exclude %python3_sitelibdir/oslo_config/tests

%files tests
%python3_sitelibdir/oslo_config/tests

%if_with docs
%files doc
%doc LICENSE *.rst html
%_man1dir/osloconfig.1.xz
%endif

%changelog
