%define oname os-client-config
%def_with check
%def_without docs

Name: python3-module-%oname
Version: 2.3.0
Release: alt1

Summary: OpenStack Client Configuration Library

License: Apache-2.0
Group: Development/Python3
Url: https://pypi.org/project/os-client-config

Source: %oname-%version.tar.gz
Source1: %oname.watch

BuildArch: noarch

BuildRequires(pre): rpm-build-python3
BuildRequires: python3-module-setuptools
BuildRequires: python3-module-wheel
BuildRequires: python3-module-pbr >= 2.0.0

%if_with check
BuildRequires: python3-module-yaml >= 3.1.0
BuildRequires: python3-module-testtools >= 2.2.0
BuildRequires: python3-module-openstacksdk >= 0.13.0
BuildRequires: python3-module-oslotest >= 3.2.0
BuildRequires: python3-module-glanceclient
BuildRequires: python3-module-coverage >= 4.0
BuildRequires: python3-module-fixtures >= 3.0.0
BuildRequires: python3-module-jsonschema >= 3.2.0
BuildRequires: python3-module-stestr >= 1.0.0
BuildRequires: python3-module-testscenarios >= 0.4
%endif

%if_with docs
BuildRequires: python3-module-sphinx
BuildRequires: python3-module-openstackdocstheme >= 1.18.1
%endif

%description
The os-client-config is a library for collecting client configuration for
using an OpenStack cloud in a consistent and comprehensive manner. It
will find cloud config for as few as 1 cloud and as many as you want to
put in a config file. It will read environment variables and config files,
and it also contains some vendor specific default values so that you don't
have to know extra info to use OpenStack

* If you have a config file, you will get the clouds listed in it
* If you have environment variables, you will get a cloud named `envvars`
* If you have neither, you will get a cloud named `defaults` with base defaults

%package tests
Summary: Tests for %oname
Group: Development/Python3
Requires: %name = %EVR

%description tests
This package contains tests for %oname.

%package doc
Summary: Documentation for OpenStack os-client-config library
Group: Development/Documentation

%description doc
Documentation for the os-client-config library.

%prep
%setup -n %oname-%version

%build
%pyproject_build

%install
%pyproject_install

%check
%__python3 -m stestr run

%files
%doc LICENSE AUTHORS ChangeLog *.rst
%python3_sitelibdir/os_client_config
%python3_sitelibdir/os_client_config-%version.dist-info
%exclude %python3_sitelibdir/os_client_config/tests

%files tests
%python3_sitelibdir/os_client_config/tests

%changelog
