%def_with check
%define _unpackaged_files_terminate_build 1
%define _stripped_files_terminate_build 1
# Relax ELF verification on aarch64 to ignore build failure due to non-object symbol
# in .dynsym section of _multiarray_umath.cpython-312.so. Strict verification is
# preserved for other architectures.
%ifarch aarch64
%set_verify_elf_method relaxed
%else
%set_verify_elf_method strict
%endif

%ifarch %ix86 ppc64le armh
%define relax_tests 1
%endif

# LTO causes errors, disable it
%global optflags_lto %nil

%define pypi_name numpy
%define oname %pypi_name

Name: python3-module-%oname
Epoch: 1
Version: 2.3.5
Release: alt1
Summary: Fundamental package for array computing in Python
License: BSD-3-Clause
Group: Development/Python3
Url: https://www.numpy.org/
VCS: https://github.com/numpy/numpy.git
Source: %name-%version.tar
Source1: %pyproject_deps_config_name
Source2: modules.tar
Source9: mesonpy.py
Patch: numpy-1.20.2-Remove-strict-dependency-on-testing-package.patch
Patch4: numpy-1.21.4-alt-use-sleep-in-auxv-test.patch

# E2K patchset with MCST numbering scheme
Source2000: 0001-arch_e2k_define.patch
Source2001: 0002-bug92804.patch

AutoReq: yes, nopython3
%pyproject_runtimedeps_metadata
BuildRequires(pre): rpm-build-pyproject
BuildRequires: gcc-c++ gcc-fortran liblapack-devel swig
# ninja and patchelf are required by vendored meson-python
BuildRequires: /usr/bin/ninja-build
BuildRequires: /usr/bin/patchelf

# ninja and patchelf are not packaged
%add_pyproject_deps_build_filter ninja
%add_pyproject_deps_build_filter patchelf
%pyproject_builddeps_build
%if_with check
# meson is not packaged
%add_pyproject_deps_check_filter meson
# ninja is not packaged
%add_pyproject_deps_check_filter ninja
%pyproject_builddeps_metadata
%pyproject_builddeps_check
# some tests want /proc/meminfo
BuildRequires: /proc
# tests require meson:
# numpy/f2py/tests/test_f2py2e.py::test_untitled_cli
# numpy/f2py/tests/test_f2py2e.py::test_no_py312_distutils_fcompiler
BuildRequires: /usr/bin/meson
%endif

%add_findprov_skiplist %python3_sitelibdir/%oname/random/_examples/*

Conflicts: python-module-numpy < 1:1.15.4-alt6
# Obsolete separate tests subpackage
Provides: %name-tests = %EVR
Obsoletes: %name-tests <= 1:2.3.4-alt1
Provides: %name-testing = %EVR
Obsoletes: %name-testing <= 1:2.3.4-alt1

%description
NumPy is the fundamental package for scientific computing in Python. It is a
Python library that provides a multidimensional array object, various derived
objects (such as masked arrays and matrices), and an assortment of routines for
fast operations on arrays, including mathematical, logical, shape manipulation,
sorting, selecting, I/O, discrete Fourier transforms, basic linear algebra,
basic statistical operations, random simulation and much more.

%package -n lib%oname-py3-devel
Summary: Development files of NumPy (Python 3)
Group: Development/Python3
Requires: %name = %EVR
Requires: python3-devel

%description -n lib%oname-py3-devel
This package contains development files of NumPy.

%prep
%setup -a2
%autopatch -p1
%ifarch %e2k
patch -p1 -i %SOURCE2000
patch -p1 -i %SOURCE2001
%endif

# headers
sed -i 's|^prefix.*|prefix=%python3_sitelibdir/%oname/_core|' \
	%oname/_core/npymath.ini.in
sed -i 's|^includedir.*|includedir=%_includedir/python%_python3_version/%oname|' \
	%oname/_core/npymath.ini.in

# remove distutils based installation configs to drop extra build deps in
# runtime
find \( -name 'setup.py' -o -name 'setup.cfg' \) -delete

%pyproject_deps_resync_build
%if_with check
%pyproject_deps_resync_check_pipreqfile requirements/test_requirements.txt
%endif

%build
%add_optflags -fno-strict-aliasing
%pyproject_build

%check
# synced to upstream CI (.github/workflows/linux.yml)
%pyproject_run -- bash -s <<-'ENDTESTS'
set -eu
cd tools
pytest --pyargs %pypi_name -ra -o=addopts=-Wignore %{?relax_tests:||:}
ENDTESTS

%install
%pyproject_install

# build of numpy is quite long process, but the METADATA is only required,
# intree build backend is patched to expect custom METADATA directory
export RPM_CUSTOM_METADATA_DIR=%buildroot%python3_sitelibdir/%{pyproject_distinfo %oname}
# path to our custom mesonpy
export PYTHONPATH=%_sourcedir
%pyproject_deps_resync_metadata

install -d %buildroot%_includedir/python%_python3_version
mv %buildroot%python3_sitelibdir/%oname/_core/include/%oname \
	%buildroot%_includedir/python%_python3_version/%oname

ln -s %_includedir/python%_python3_version/%oname \
	%buildroot%python3_sitelibdir/%oname/_core/include/

%files
%doc README.md
%_bindir/f2py*
%python3_sitelibdir/%oname
%python3_sitelibdir/%{pyproject_distinfo %oname}/
%exclude %python3_sitelibdir/%oname/tests
%exclude %python3_sitelibdir/%oname/*/tests/
%exclude %python3_sitelibdir/%oname/*/test_*
%exclude %python3_sitelibdir/%oname/*/__pycache__/test_*.*
%exclude %python3_sitelibdir/%oname/f2py/src/fortranobject.h
%exclude %python3_sitelibdir/%oname/_core/lib/npy-pkg-config
%exclude %python3_sitelibdir/%oname/doc
%exclude %python3_sitelibdir/%oname/_core/include
%exclude %python3_sitelibdir/%oname/f2py/src
%exclude %python3_sitelibdir/%oname/_core/lib/libnpymath.a
%exclude %python3_sitelibdir/%oname/random/lib/libnpyrandom.a

%files -n lib%oname-py3-devel
%_bindir/numpy-config
%_includedir/python%_python3_version/%oname
%python3_sitelibdir/%oname/_core/include
%python3_sitelibdir/%oname/f2py/src
%python3_sitelibdir/%oname/_core/lib/npy-pkg-config
%python3_sitelibdir/%oname/_core/lib/libnpymath.a
%python3_sitelibdir/%oname/random/lib/libnpyrandom.a

%changelog
