%define oname numdifftools

%def_with check

Name: python3-module-%oname
Version: 0.9.41
Release: alt3

Summary: Solves automatic numerical differentiation problems in one or more variables

License: BSD-3-Clause
Group: Development/Python3
Url: https://pypi.org/project/numdifftools
VCS: https://github.com/pbrod/numdifftools
BuildArch: noarch
Source: %name-%version.tar
Patch0: nd-0.9.41-alt-fix-pytest-runner.patch

BuildRequires(pre): rpm-build-python3
BuildRequires: python3-module-setuptools
BuildRequires: python3-module-wheel
%if_with check
BuildRequires: xvfb-run
BuildRequires: python3-module-algopy
BuildRequires: python3-module-hypothesis
BuildRequires: python3-module-matplotlib
BuildRequires: python3-module-matplotlib-tk
BuildRequires: python3-module-statsmodels
BuildRequires: python3-module-pandas-tests
%endif

%description
Numdifftools is a suite of tools to solve automatic numerical
differentiation problems in one or more variables. All of these methods
also produce error estimates on the result.

%package tests
Summary: Tests for %oname
Group: Development/Python3
Requires: %name = %EVR
Requires: python3-module-algopy
Requires: python3-module-scikits.statsmodels
Requires: python3-module-pandas-tests

%description tests
Numdifftools is a suite of tools to solve automatic numerical
differentiation problems in one or more variables. All of these methods
also produce error estimates on the result.

This package contains tests for %oname.

%prep
%setup
%patch0

%build
%pyproject_build

%install
%pyproject_install

%check
# support numpy 1.25.2 https://github.com/pbrod/numdifftools/issues/72
#export PYTHONPATH=%buildroot%python3_sitelibdir
xvfb-run -a -s "-screen 0 640x480x24" \
py.test-3 -v src/%oname/tests/ -k "\
not test_high_order_derivative \
and not test_low_order_derivative_on_example_functions \
and not test_sinx_div_x \
and not test_complex_hessian_issue_35"

%files
%doc LICENSE.txt *.rst
%python3_sitelibdir/%oname
%python3_sitelibdir/%{pyproject_distinfo %oname}
%exclude %python3_sitelibdir/%oname/tests

%files tests
%python3_sitelibdir/%oname/tests
%doc LICENSE.txt *.rst

%changelog
