%define  oname numba

# check runs 3 hours on x86_64
# FAIL: test_nonsense_gdb_binary (numba.tests.test_cli.TestGDBCLIInfoBrokenGdbs.test_nonsense_gdb_binary)
# FAIL: tests_numba_types (numba.tests.test_moved_modules.TestMovedModule.tests_numba_types)
# FAIL: test_record_arg_transform (numba.tests.test_record_dtype.TestRecordDtype.test_record_arg_transform)
# FAIL: test_record_arg_transform (numba.tests.test_record_dtype.TestRecordDtypeWithDispatcher.test_record_arg_transform)
# FAIL: test_record_arg_transform (numba.tests.test_record_dtype.TestRecordDtypeWithStructArrays.test_record_arg_transform)
# FAIL: test_record_arg_transform (numba.tests.test_record_dtype.TestRecordDtypeWithStructArraysAndDispatcher.test_record_arg_transform)
# FAIL: test_has_no_error (numba.tests.test_sysinfo.TestSysInfo.test_has_no_error)
# Ran 10356 tests in 11587.148s
# FAILED (failures=7, skipped=643, expected failures=20)
%def_without check

Name:    python3-module-%oname
Version: 0.62.1
Release: alt1

Summary: A Just-In-Time Compiler for Numerical Functions in Python

License: BSD
Group:   Development/Python3
URL:     https://pypi.org/project/numba

Packager: Grigory Ustinov <grenka@altlinux.org>

BuildRequires(pre): rpm-build-python3
BuildRequires: gcc-c++ libgomp-devel libnumpy-py3-devel
BuildRequires: python3-module-setuptools
BuildRequires: python3-module-wheel

%if_with check
BuildRequires: python3-module-llvmlite
BuildRequires: python3-module-numpy-testing
%endif

Source:  %name-%version.tar

%add_python3_self_prov_path %buildroot%python3_sitelibdir/%oname/tests/pycc_distutils_usecase/

%add_python3_req_skip numba_rvsdg.core.datastructures
%add_python3_req_skip numba_rvsdg.core.datastructures.basic_block
%add_python3_req_skip numba_rvsdg.core.datastructures.byte_flow
%add_python3_req_skip numba_rvsdg.core.datastructures.scfg
%add_python3_req_skip numba_rvsdg.rendering.rendering

%description
Numba is an open source, NumPy-aware optimizing compiler for Python sponsored by
Anaconda, Inc. It uses the LLVM compiler project to generate machine code from
Python syntax.

Numba can compile a large subset of numerically-focused Python, including many
NumPy functions. Additionally, Numba has support for automatic parallelization
of loops, generation of GPU-accelerated code, and creation of ufuncs and
C callbacks.

%prep
%setup
# workaround for versioneer
rm versioneer.py
grep -qsF ' export-subst' .gitattributes || exit 1
vers_f="$(sed -n 's/ export-subst//p' .gitattributes)"
echo 'def get_versions():return {"version": "%version"}' > "$vers_f"
echo 'def get_cmdclass(): return {}' > versioneer.py
echo 'def get_version(): return "%version"' >> versioneer.py

%ifarch %e2k
# error: misspelling pragma string
sed -i "/omp parallel/s/),/)/" numba/np/ufunc/omppool.cpp
%endif

%build
%pyproject_build

%install
%pyproject_install

mv %buildroot%_bindir/numba %buildroot%_bindir/numba3

# Tests bring lots of dependencies! See ALT#52000
rm -rv %buildroot%python3_sitelibdir/%oname/tests
rm -rv %buildroot%python3_sitelibdir/%oname/testing
rm -rv %buildroot%python3_sitelibdir/%oname/runtests.py
rm -rv %buildroot%python3_sitelibdir/%oname/cuda/tests
rm -rv %buildroot%python3_sitelibdir/%oname/cuda/testing.py
rm -rv %buildroot%python3_sitelibdir/%oname/core/datamodel/testing.py
rm -rv %buildroot%python3_sitelibdir/%oname/misc/POST.py
rm -rv %buildroot%python3_sitelibdir/%oname/misc/help/inspector.py

%check
mkdir emtpytestdir
pushd emtpytestdir
export PYTHONPATH=%buildroot%python3_sitelibdir
%__python3 -m numba.runtests -v
popd

%files
%doc CHANGE_LOG *.rst
%_bindir/numba3
%python3_sitelibdir/%oname
%python3_sitelibdir/%oname-%version.dist-info

%changelog
