%define _unpackaged_files_terminate_build 1
%define pypi_name networkx

# some tests fail on i586 (oom issues)
%ifarch i586
%def_without check
%else
%def_with check
%endif

Name:           python3-module-%pypi_name
Epoch:          2
Version:        3.6
Release:        alt1
Summary:        Creates and Manipulates Graphs and Networks
Group:          Development/Python3
License:        BSD-3-Clause
URL:            http://networkx.github.io
VCS:            https://github.com/networkx/networkx.git

BuildArch:      noarch

Source: %name-%version.tar
BuildRequires(pre): rpm-build-python3
BuildRequires: python3-module-setuptools
BuildRequires: python3-module-wheel
%if_with check
BuildRequires: python3-module-pandas-tests
BuildRequires: python3-module-numpy
BuildRequires: python3-module-matplotlib
BuildRequires: python3-module-lxml
BuildRequires: python3-module-fonttools
BuildRequires: python3-module-pygraphviz
BuildRequires: graphviz
BuildRequires: fontconfig
%endif

Requires: %name-drawing = %EVR

%description
NetworkX is a Python package for the creation, manipulation, and
study of the structure, dynamics, and functions of complex networks.

%package core
Summary: Creates and Manipulates Graphs and Networks (Python 3)
Group: Development/Python3
Requires: python3-module-decorator
Requires: python3-module-yaml
%add_python3_req_skip tests
%add_python3_req_skip networkx.tests.test

%description core
NetworkX is a Python package for the creation, manipulation, and
study of the structure, dynamics, and functions of complex networks.

%package drawing
Summary: Creates and Manipulates Graphs and Networks (Python 3)
Group: Development/Python3
Requires: %name-core = %EVR
Requires: python3-module-pygraphviz >= 1.5
Requires: python3-module-pygraphviz < 2.0
Requires: python3-module-pydot >= 1.4.1
Requires: python3-module-matplotlib >= 3.2

%description drawing
NetworkX is a Python package for the creation, manipulation, and
study of the structure, dynamics, and functions of complex networks.

This package provides support for graph visualizations.

%package tests
Summary: Tests for NetworkX (Python 3)
Group: Development/Python3
Requires: %name = %EVR

%description tests
NetworkX is a Python package for the creation, manipulation, and
study of the structure, dynamics, and functions of complex networks.

This package contains tests for NetworkX.

%prep
%setup

%build
%pyproject_build

%install
%pyproject_install

%check
%pyproject_run_pytest -vra -k "\
not test_pygraphviz_layout_root \
and not test_graphviz_alias"

%files

%files core
%doc LICENSE.txt
%doc README.rst CODE_OF_CONDUCT.rst CONTRIBUTING.rst
%python3_sitelibdir/%pypi_name
%python3_sitelibdir/%pypi_name-%version.dist-info
%exclude %python3_sitelibdir/%pypi_name/drawing
%exclude %python3_sitelibdir/%pypi_name/tests
%exclude %python3_sitelibdir/%pypi_name/conftest.py
%exclude %python3_sitelibdir/%pypi_name/__pycache__/conftest.*
%exclude %python3_sitelibdir/%pypi_name/*/tests
%exclude %python3_sitelibdir/%pypi_name/*/*/tests

%files drawing
%python3_sitelibdir/%pypi_name/drawing
%exclude %python3_sitelibdir/%pypi_name/drawing/tests

%files tests
%python3_sitelibdir/%pypi_name/conftest.py
%python3_sitelibdir/%pypi_name/__pycache__/conftest.*
%python3_sitelibdir/%pypi_name/tests
%python3_sitelibdir/%pypi_name/*/tests
%python3_sitelibdir/%pypi_name/*/*/tests

%changelog
