%define _unpackaged_files_terminate_build 1
%define pypi_name mypy
%def_with check

# mypyc doesn't work on 32bit arches
# https://github.com/mypyc/mypyc/issues/760
%ifarch %ix86 armh
%def_without mypyc
%else
%def_with mypyc
%endif

Name: python3-module-%pypi_name
Version: 1.18.1
Release: alt1
Summary: Optional static typing for Python
License: MIT
Group: Development/Python3
Url: https://pypi.org/project/mypy/
VCS: https://github.com/python/mypy
Source: %name-%version.tar
Source1: %pyproject_deps_config_name
Patch0: %name-%version-alt.patch
# manually manage runtime dependencies with metadata
AutoReq: yes, nopython3
%pyproject_runtimedeps_metadata
BuildRequires(pre): rpm-build-pyproject
%add_pyproject_deps_build_filter types-
%pyproject_builddeps_build
%if_with check
BuildRequires: /proc
BuildRequires: gcc-c++
%pyproject_builddeps_metadata
%pyproject_builddeps_check
# required for mypy/test/testpep561.py
BuildRequires: python3-module-hatchling
BuildRequires: python3-module-editables
%endif
# Needed to generate the man pages
BuildRequires: help2man

%description
Mypy is an optional static type checker for Python that aims to combine the
benefits of dynamic (or "duck") typing and static typing. Mypy combines the
expressive power and convenience of Python with a powerful type system and
compile-time type checking. Mypy type checks standard Python programs; run them
using any Python VM with basically no runtime overhead.

%if_with mypyc
%package -n python3-module-mypyc
Summary: Mypy to Python C Extension Compiler
Group: Development/Python3
# manually manage runtime dependencies with metadata
AutoReq: yes, nopython3
Requires: python3-module-%pypi_name = %EVR
Requires: python3-dev

%description -n python3-module-mypyc
Mypyc is a compiler that compiles mypy-annotated, statically typed Python
modules into CPython C extensions. Currently our primary focus is on making
mypy faster through compilation -- the default mypy wheels are compiled with
mypyc. Compiled mypy is about 4x faster than without compilation.
%endif

%prep
%setup
%autopatch -p1
%pyproject_deps_resync_build
%pyproject_deps_resync_metadata
%if_with check
%pyproject_deps_resync_check_pipreqfile test-requirements.in
%endif

%build
%pyproject_build

%install
%pyproject_install

%if "%python3_sitelibdir" != "%python3_sitelibdir_noarch"
    mkdir -p %buildroot%python3_sitelibdir
    mv %buildroot%python3_sitelibdir_noarch/* %buildroot%python3_sitelibdir/
%endif

mv %buildroot%python3_sitelibdir/mypy/{typeshed,mypy_typeshed}
ln -sr %buildroot%python3_sitelibdir/mypy/{mypy_typeshed,typeshed}

# Generate man pages
mkdir -p %buildroot%_man1dir

PYTHONPATH=%buildroot%python3_sitelibdir \
    help2man --no-info --version-string 'mypy %version-dev' \
        --no-discard-stderr -o %buildroot%_man1dir/mypy.1 \
        %buildroot%_bindir/mypy

PYTHONPATH=%buildroot%python3_sitelibdir \
    help2man --no-info --version-string 'mypy stubgen %version-dev' \
        --no-discard-stderr -o %buildroot%_man1dir/stubgen.1 \
        %buildroot%_bindir/stubgen

# don't package tests
rm -r %buildroot%python3_sitelibdir/%pypi_name/test/
rm -r %buildroot%python3_sitelibdir/mypyc/test/

%if_without mypyc
rm %buildroot%_bindir/mypyc
rm -r %buildroot%python3_sitelibdir/mypyc/
%endif

%check
# https://github.com/mypyc/mypyc/issues/760
%ifarch %ix86 armh
%define pytest_args --ignore mypyc/test
%endif
# https://github.com/python/mypy/issues/18610
# disable CPython assertions
export CFLAGS="${CFLAGS:-%optflags} -DNDEBUG"
%pyproject_run_pytest -ra %{?pytest_args}

%files
%doc README.md
%python3_sitelibdir/mypy/
%python3_sitelibdir/%{pyproject_distinfo %pypi_name}/
%_bindir/mypy
%_bindir/dmypy
%_bindir/stubgen
%_bindir/stubtest
%_man1dir/mypy.1*
%_man1dir/stubgen.1*

%if_with mypyc
%files -n python3-module-mypyc
%python3_sitelibdir/mypyc/
%_bindir/mypyc
%endif

%changelog
