%define _unpackaged_files_terminate_build 1
%define pypi_name moto

%def_with check
# full testsuite takes too long for now, run it locally
# name                      aarch64   armh   i586  ppc64le  x86_64
# python3-module-moto         20:32  35:22  12:18    25:10   12:09
%def_without full_testsuite

Name: python3-module-%pypi_name
Version: 5.1.12
Release: alt1

Summary: A library that allows your python tests to easily mock out the boto library
License: Apache-2.0
Group: Development/Python3
Url: https://pypi.org/project/moto/
Vcs: https://github.com/getmoto/moto
BuildArch: noarch
Source: %name-%version.tar
Source1: %pyproject_deps_config_name
Patch: %name-%version-alt.patch
# manage deps with metadata
AutoReq: yes, nopython3
%pyproject_runtimedeps_metadata
BuildRequires(pre): rpm-build-pyproject
%pyproject_builddeps_build
%if_with check
%add_pyproject_deps_check_filter cfn-lint
%add_pyproject_deps_check_filter py-partiql-parser
%add_pyproject_deps_check_filter joserfc
%add_pyproject_deps_check_filter antlr4-python3-runtime
# not packaged
%add_pyproject_deps_check_filter pycognito
%pyproject_builddeps_metadata_extra all
%pyproject_builddeps_metadata_extra server
%pyproject_builddeps_check
%endif

%description
Moto is a library that allows your python tests to easily mock out the
boto library.

%prep
%setup
%autopatch -p1
%pyproject_deps_resync_build
%pyproject_deps_resync_metadata
%if_with check
%pyproject_deps_resync_check_pipreqfile requirements-tests.txt
%endif

%build
%pyproject_build

%install
%pyproject_install

%check
export TESTS_SKIP_REQUIRES_DOCKER=YES
%if_with full_testsuite
export TESTS=tests
%else
export TESTS=tests/test_core
%endif
%pyproject_run_pytest $TESTS -m 'not network' -ra -Wignore \
    --ignore tests/test_cognitoidp/test_cognitoidp.py \

%files
%doc README.*
%_bindir/moto_server
%_bindir/moto_proxy
%python3_sitelibdir/%pypi_name
%python3_sitelibdir/%{pyproject_distinfo %pypi_name}/

%changelog
