%define pypi_name py-moneyed
%define mod_name moneyed

%def_with check

Name: python3-module-%mod_name
Version: 3.0
Release: alt2
Summary: Provides Currency and Money classes for use in your Python code
License: BSD
Group: Development/Python3
Url: https://pypi.org/project/py-moneyed/
Vcs: https://github.com/py-moneyed/py-moneyed
BuildArch: noarch
Source: %name-%version.tar

Patch: add-missing-currencies.patch

# mapping from PyPI name
# https://www.altlinux.org/Management_of_Python_dependencies_sources#Mapping_project_names_to_distro_names
Provides: python3-module-%{pep503_name %pypi_name} = %EVR

BuildRequires(pre): rpm-build-python3

BuildRequires: python3-module-setuptools
BuildRequires: python3-module-wheel

%if_with check
BuildRequires: python3-module-babel
BuildRequires: python3-module-typing_extensions
%endif

%description
The need to represent instances of money frequently arises in software
development, particularly any financial/economics software. To address
that need, the py-moneyed package provides the classes of Money and
Currency, at a level more useful than just using Python's Decimal class,
or ($DEITY forbid) the float primitive. The package is meant to be
stand-alone and easy to either use directly, or subclass further.

%prep
%setup
%patch -p1

%build
%pyproject_build

%install
%pyproject_install

%check
%pyproject_run_pytest -vra

%files
%doc README.*
%python3_sitelibdir/%mod_name/
%python3_sitelibdir/%{pyproject_distinfo %pypi_name}/

%changelog
