%define _unpackaged_files_terminate_build 1
%define pypi_name mkdocs

%def_with check

Name: python3-module-%pypi_name
Version: 1.6.1
Release: alt2

Summary: Project documentation with Markdown
License: BSD-2-Clause
Group: Development/Python3
Url: https://pypi.org/project/mkdocs/
Vcs: https://github.com/mkdocs/mkdocs
BuildArch: noarch

Source: %name-%version.tar
Source1: %pyproject_deps_config_name
Patch0: %name-%version-alt.patch
%pyproject_runtimedeps_metadata
BuildRequires(pre): rpm-build-pyproject
%pyproject_builddeps_build
%if_with check
%pyproject_builddeps_metadata
%endif
BuildRequires: fonts-font-awesome

%description
MkDocs is a fast, simple and downright gorgeous static site generator
that's geared towards building project documentation. Documentation
source files are written in Markdown, and configured with a single YAML
configuration file.

%prep
%setup
%autopatch -p1
%pyproject_deps_resync_build
%pyproject_deps_resync_metadata

%build
%pyproject_build

%install
%pyproject_install

# unbundle font-awesome fonts
FONT_AWESOME_FONTS='%_datadir/fonts-font-awesome/fonts'

fonts_bundled=
for f in $(find -P %buildroot%python3_sitelibdir/mkdocs/themes/*/*/fonts/ -name 'fontawesome-webfont.*' -type f);
do
    printf "Found fontawesome font: '%%s'\n" "$f"
    font_name="$(basename "$f")"
    system_font="$FONT_AWESOME_FONTS/$font_name"
    if [ ! -f "$system_font" ]; then
        # raise to be sure we have synced fonts (bundled vs system)
        printf "Unknown font name: '%%s'\n" "$font_name"
        exit 1
    fi

    ln -sfT "$system_font" "$f"
    fonts_bundled=yes
done
[ "$fonts_bundled" != "yes" ] && exit 1

%check
# https://github.com/mkdocs/mkdocs/issues/4014
rm -rf mkdocs/tests/cli_tests.py
# synced to pyproject.toml:tool.hatch.envs.test.scripts
%pyproject_run_unittest discover -p '*tests.py' mkdocs --top-level-directory .

%files
%_bindir/mkdocs
%python3_sitelibdir/mkdocs/
%python3_sitelibdir/%{pyproject_distinfo %pypi_name}/

%changelog
