%define oname matplotlib

# Failed lots of tests because of freetype version mismatch
%def_without check

%def_with gtk4
%def_with qt5
%def_with qt6
%def_with wx

Name: python3-module-%oname
Version: 3.10.8
Release: alt1

Summary: Matlab(TM) style python plotting package

License: PSF-2.0 and MIT and CC0-1.0
Group: Development/Python3
URL: https://pypi.org/project/matplotlib
# https://matplotlib.sourceforge.net
VCS: https://github.com/matplotlib/matplotlib

Source: %oname-%version.tar

Patch: matplotlibrc-path-search-fix.patch
Patch1: matplotlib-build-options.patch
Patch2: matplotlib-Set-FreeType-version-to-2.13.3-and-update-tolerances.patch

BuildRequires(pre): rpm-build-python3
BuildRequires: python3-module-setuptools
BuildRequires: python3-module-setuptools-scm
BuildRequires: python3-module-wheel
BuildRequires: python3-module-mesonpy
BuildRequires: meson

BuildRequires: gcc-c++
BuildRequires: tk-devel
BuildRequires: libgtk+3-gir-devel
BuildRequires: libpng-devel
BuildRequires: libfreetype-devel
BuildRequires: libqhull-devel
BuildRequires: libnumpy-py3-devel
BuildRequires: python3-module-pybind11

%if_with check
BuildRequires: xvfb-run
BuildRequires: python3-module-pytest
BuildRequires: python3-module-Pillow
BuildRequires: python3-module-pyparsing
BuildRequires: python3-module-cycler
BuildRequires: python3-module-dateutil
BuildRequires: python3-module-kiwisolver
BuildRequires: python3-module-numpy-testing
BuildRequires: python3-module-numpy-tests
BuildRequires: python3-module-fonttools
BuildRequires: python3-module-contourpy
%endif

%{?_with_qt5:BuildRequires: python3-module-PyQt5}
%{?_with_qt6:BuildRequires: python3-module-PyQt6}

Requires: python3-module-mpl_toolkits = %EVR
Requires: %name-data = %EVR
%add_python3_req_skip builtins fontTools

%description
matplotlib is a pure python 2D plotting library with a Matlab(TM)
syntax which produces publication quality figures using in a
variety of hardcopy formats (PNG, JPG, TIFF, PS) and interactive
GUI environments (WX, GTK) across platforms. matplotlib can be used
in python scripts, interactively from the python shell (ala matlab
or mathematica), in web application servers generating dynamic
charts, or embedded in GTK or WX applications; see backends.

%if_with qt6
%package qt6
Summary: qt6 backend for %oname
Group: Development/Python3
Requires: %name = %EVR
%py3_requires PyQt6

%description qt6
qt6 backend for %oname.
%endif

%if_with qt5
%package qt5
Summary: qt5 backend for %oname
Group: Development/Python3
Requires: %name = %EVR
%py3_requires PyQt5

%description qt5
qt5 backend for %oname.
%endif

%package cairo
Summary: Cairo backend for %oname
Group: Development/Python3
Requires: %name = %EVR
%py3_requires cairo

%description cairo
Cairo backend for %oname.

%package nbagg
Summary: Interactive figures in the IPython notebook
Group: Development/Python3
Requires: %name = %EVR

%description nbagg
Interactive figures in the IPython notebook.

%package backend_gtk
Summary: backend for python3-module-%oname-gtk3 and python3-module-%oname-gtk4
Group: Development/Python3

%description backend_gtk
%summary

%package gtk3
Summary: gtk3 backend for %oname
Group: Development/Python3
Requires: %name-cairo = %EVR
Requires: typelib(Gtk) = 3.0
Requires: python3-module-pygobject3

%description gtk3
gtk3 backend for %oname.

%package gtk4
Summary: gtk4 backend for %oname
Group: Development/Python3
Requires: %name-cairo = %EVR
Requires: typelib(Gtk) = 4.0

%description gtk4
gtk4 backend for %oname.

%package web
Summary: Web backend for %oname
Group: Development/Python3
Requires: python3-module-tornado

%description web
Web backend for %oname.

%package wx
Summary: wx backend for %oname
Group: Development/Python3
Requires: %name = %EVR

%description wx
ex backend for %oname.

%package tk
Summary: tk backend for %oname
Group: Development/Python3
Requires: %name = %EVR
%py3_requires _tkinter

%description tk
tk backend for %oname.

%package sphinxext
Summary: sphinxext extension for %oname
Group: Development/Python3
Requires: %name = %EVR

%description sphinxext
sphinxext extension for %oname.

%package -n python3-module-mpl_toolkits
Summary: mpl_toolkits extension for %oname
Group: Development/Python3

%description -n python3-module-mpl_toolkits
mpl_toolkits extension for %oname.

%package data
Summary: Data used by python-matplotlib
Group: Development/Python3
BuildArch: noarch

%description data
Data used by python-matplotlib

%prep
%setup
%patch -p1
%patch1 -p1
%patch2 -p1

%build
%add_optflags -fno-strict-aliasing
export SETUPTOOLS_SCM_PRETEND_VERSION=%version
%pyproject_build

%install
export SETUPTOOLS_SCM_PRETEND_VERSION=%version
%pyproject_install
cp -fR lib/mpl_toolkits %buildroot%python3_sitelibdir/

# don't package tests
rm -rv %buildroot%python3_sitelibdir/%oname/testing
rm -rv %buildroot%python3_sitelibdir/%oname/tests
rm -rv %buildroot%python3_sitelibdir/mpl_toolkits/*/tests

mkdir -p %buildroot%_datadir/matplotlib
mv %buildroot%python3_sitelibdir/matplotlib/mpl-data \
   %buildroot%_datadir/matplotlib

%check
export PYTHONPATH=%buildroot%python3_sitelibdir
export MPLCONFIGDIR=%buildroot%python3_sitelibdir/%oname/mpl-data/matplotlibrc
xvfb-run -a -s "-screen 0 640x480x24" \
py.test-3 --pyargs matplotlib.tests \
                           mpl_toolkits.axes_grid1.tests \
                           mpl_toolkits.axisartist.tests \
                           mpl_toolkits.mplot3d.tests \
                           -m "not network" \

%files
%doc README.md
%python3_sitelibdir/*.py*
%python3_sitelibdir/__pycache__
%python3_sitelibdir/%oname-%version.dist-info
%dir %python3_sitelibdir/matplotlib
%python3_sitelibdir/matplotlib/*.py*
%python3_sitelibdir/matplotlib/*.so
%python3_sitelibdir/matplotlib/__pycache__
%python3_sitelibdir/matplotlib/_api
%python3_sitelibdir/matplotlib/axes
%python3_sitelibdir/matplotlib/backends
%python3_sitelibdir/matplotlib/projections
%python3_sitelibdir/matplotlib/style
%python3_sitelibdir/matplotlib/tri
%python3_sitelibdir/matplotlib/py.typed
%exclude %python3_sitelibdir/matplotlib/backends/_backend_tk.py
%exclude %python3_sitelibdir/matplotlib/backends/_backend_gtk.py
%exclude %python3_sitelibdir/matplotlib/backends/_tkagg.*
%exclude %python3_sitelibdir/matplotlib/backends/backend_cairo.*
%exclude %python3_sitelibdir/matplotlib/backends/backend_nbagg.*
%exclude %python3_sitelibdir/matplotlib/backends/backend_gtk3.*
%exclude %python3_sitelibdir/matplotlib/backends/backend_gtk3agg.*
%exclude %python3_sitelibdir/matplotlib/backends/backend_gtk3cairo.*
%exclude %python3_sitelibdir/matplotlib/backends/backend_gtk4.*
%exclude %python3_sitelibdir/matplotlib/backends/backend_gtk4agg.*
%exclude %python3_sitelibdir/matplotlib/backends/backend_gtk4cairo.*
%exclude %python3_sitelibdir/matplotlib/backends/backend_qt5.*
%exclude %python3_sitelibdir/matplotlib/backends/backend_qt5agg.*
%exclude %python3_sitelibdir/matplotlib/backends/backend_qt5cairo.py*
%exclude %python3_sitelibdir/matplotlib/backends/backend_qt.*
%exclude %python3_sitelibdir/matplotlib/backends/backend_qtagg.*
%exclude %python3_sitelibdir/matplotlib/backends/backend_qtcairo.py*
%exclude %python3_sitelibdir/matplotlib/backends/backend_tkagg.*
%exclude %python3_sitelibdir/matplotlib/backends/backend_tkcairo.*
%exclude %python3_sitelibdir/matplotlib/backends/backend_webagg.*
%exclude %python3_sitelibdir/matplotlib/backends/backend_webagg_core.*
%exclude %python3_sitelibdir/matplotlib/backends/backend_wx.*
%exclude %python3_sitelibdir/matplotlib/backends/backend_wxagg.*
%exclude %python3_sitelibdir/matplotlib/backends/backend_wxcairo.*
%exclude %python3_sitelibdir/matplotlib/backends/qt_compat.*
%exclude %python3_sitelibdir/matplotlib/backends/qt_editor
%exclude %python3_sitelibdir/matplotlib/backends/web_backend
%exclude %python3_sitelibdir/matplotlib/backends/__pycache__/_backend_tk.*.py*
%exclude %python3_sitelibdir/matplotlib/backends/__pycache__/_backend_gtk.*.py*
%exclude %python3_sitelibdir/matplotlib/backends/__pycache__/backend_cairo.*.py*
%exclude %python3_sitelibdir/matplotlib/backends/__pycache__/backend_nbagg.*.py*
%exclude %python3_sitelibdir/matplotlib/backends/__pycache__/backend_gtk3.*.py*
%exclude %python3_sitelibdir/matplotlib/backends/__pycache__/backend_gtk3agg.*.py*
%exclude %python3_sitelibdir/matplotlib/backends/__pycache__/backend_gtk3cairo.*.py*
%exclude %python3_sitelibdir/matplotlib/backends/__pycache__/backend_gtk4.*.py*
%exclude %python3_sitelibdir/matplotlib/backends/__pycache__/backend_gtk4agg.*.py*
%exclude %python3_sitelibdir/matplotlib/backends/__pycache__/backend_gtk4cairo.*.py*
%exclude %python3_sitelibdir/matplotlib/backends/__pycache__/backend_qt5.*.py*
%exclude %python3_sitelibdir/matplotlib/backends/__pycache__/backend_qt5agg.*.py*
%exclude %python3_sitelibdir/matplotlib/backends/__pycache__/backend_qt5cairo.*.py*
%exclude %python3_sitelibdir/matplotlib/backends/__pycache__/backend_qt.*.py*
%exclude %python3_sitelibdir/matplotlib/backends/__pycache__/backend_qtagg.*.py*
%exclude %python3_sitelibdir/matplotlib/backends/__pycache__/backend_qtcairo.*.py*
%exclude %python3_sitelibdir/matplotlib/backends/__pycache__/backend_tkagg.*.py*
%exclude %python3_sitelibdir/matplotlib/backends/__pycache__/backend_tkcairo.*.py*
%exclude %python3_sitelibdir/matplotlib/backends/__pycache__/backend_webagg.*.py*
%exclude %python3_sitelibdir/matplotlib/backends/__pycache__/backend_webagg_core.*.py*
%exclude %python3_sitelibdir/matplotlib/backends/__pycache__/backend_wx.*.py*
%exclude %python3_sitelibdir/matplotlib/backends/__pycache__/backend_wxagg.*.py*
%exclude %python3_sitelibdir/matplotlib/backends/__pycache__/backend_wxcairo.*.py*
%exclude %python3_sitelibdir/matplotlib/backends/__pycache__/qt_compat.*.py*
%exclude %python3_sitelibdir/mpl_toolkits

%files cairo
%doc README.md
%python3_sitelibdir/matplotlib/backends/backend_cairo.py*
%python3_sitelibdir/matplotlib/backends/__pycache__/backend_cairo.*.py*

%files nbagg
%doc README.md
%python3_sitelibdir/matplotlib/backends/backend_nbagg.py*
%python3_sitelibdir/matplotlib/backends/__pycache__/backend_nbagg.*.py*

%files backend_gtk
%doc README.md
%python3_sitelibdir/matplotlib/backends/_backend_gtk.py
%python3_sitelibdir/matplotlib/backends/__pycache__/_backend_gtk.*

%files gtk3
%doc README.md
%python3_sitelibdir/matplotlib/backends/backend_gtk3.py*
%python3_sitelibdir/matplotlib/backends/backend_gtk3agg.py*
%python3_sitelibdir/matplotlib/backends/backend_gtk3cairo.py*
%python3_sitelibdir/matplotlib/backends/__pycache__/backend_gtk3.*.py*
%python3_sitelibdir/matplotlib/backends/__pycache__/backend_gtk3agg.*.py*
%python3_sitelibdir/matplotlib/backends/__pycache__/backend_gtk3cairo.*.py*

%if_with gtk4
%files gtk4
%doc README.md
%python3_sitelibdir/matplotlib/backends/backend_gtk4.py*
%python3_sitelibdir/matplotlib/backends/backend_gtk4agg.py*
%python3_sitelibdir/matplotlib/backends/backend_gtk4cairo.py*
%python3_sitelibdir/matplotlib/backends/__pycache__/backend_gtk4.*.py*
%python3_sitelibdir/matplotlib/backends/__pycache__/backend_gtk4agg.*.py*
%python3_sitelibdir/matplotlib/backends/__pycache__/backend_gtk4cairo.*.py*
%endif

%files tk
%doc README.md
%python3_sitelibdir/matplotlib/backends/_backend_tk.py*
%python3_sitelibdir/matplotlib/backends/backend_tkagg.py*
%python3_sitelibdir/matplotlib/backends/backend_tkcairo.py*
%python3_sitelibdir/matplotlib/backends/_tkagg.*
%python3_sitelibdir/matplotlib/backends/__pycache__/_backend_tk.*.py*
%python3_sitelibdir/matplotlib/backends/__pycache__/backend_tkagg.*.py*
%python3_sitelibdir/matplotlib/backends/__pycache__/backend_tkcairo.*.py*

%files web
%doc README.md
%python3_sitelibdir/matplotlib/backends/backend_webagg.py*
%python3_sitelibdir/matplotlib/backends/backend_webagg_core.py*
%python3_sitelibdir/matplotlib/backends/web_backend
%python3_sitelibdir/matplotlib/backends/__pycache__/backend_webagg.*.py*
%python3_sitelibdir/matplotlib/backends/__pycache__/backend_webagg_core.*.py*

%if_with qt5
%files qt5
%doc README.md
%python3_sitelibdir/matplotlib/backends/backend_qt5.py*
%python3_sitelibdir/matplotlib/backends/backend_qt5agg.py*
%python3_sitelibdir/matplotlib/backends/backend_qt5cairo.py*
%python3_sitelibdir/matplotlib/backends/qt_compat.py*
%python3_sitelibdir/matplotlib/backends/qt_editor
%python3_sitelibdir/matplotlib/backends/__pycache__/backend_qt5.*.py*
%python3_sitelibdir/matplotlib/backends/__pycache__/backend_qt5agg.*.py*
%python3_sitelibdir/matplotlib/backends/__pycache__/backend_qt5cairo.*.py*
%python3_sitelibdir/matplotlib/backends/__pycache__/qt_compat.*.py*
%endif

%if_with qt6
%files qt6
%python3_sitelibdir/matplotlib/backends/backend_qt.py*
%python3_sitelibdir/matplotlib/backends/backend_qtagg.py*
%python3_sitelibdir/matplotlib/backends/backend_qtcairo.py*
%python3_sitelibdir/matplotlib/backends/__pycache__/backend_qt.*.py*
%python3_sitelibdir/matplotlib/backends/__pycache__/backend_qtagg.*.py*
%python3_sitelibdir/matplotlib/backends/__pycache__/backend_qtcairo.*.py*
%endif

%if_with wx
%files wx
%doc README.md
%python3_sitelibdir/matplotlib/backends/backend_wx.py*
%python3_sitelibdir/matplotlib/backends/backend_wxagg.py*
%python3_sitelibdir/matplotlib/backends/backend_wxcairo.py*
%python3_sitelibdir/matplotlib/backends/__pycache__/backend_wx.*.py*
%python3_sitelibdir/matplotlib/backends/__pycache__/backend_wxagg.*.py*
%python3_sitelibdir/matplotlib/backends/__pycache__/backend_wxcairo.*.py*
%endif

%files sphinxext
%doc README.md
%python3_sitelibdir/%oname/sphinxext

%files -n python3-module-mpl_toolkits
%doc README.md
%python3_sitelibdir/mpl_toolkits

%files data
%doc README.md
%dir %_datadir/matplotlib
%_datadir/matplotlib/mpl-data

%changelog
