%define modulename markdown2

%def_disable check

Name: python3-module-%modulename
Version: 2.3.10
Release: alt1

Summary: Another implementation of Markdown in Python
License: %gpl2plus | %bsd
Group: Development/Python3
Url: http://code.google.com/p/python-markdown2/
BuildArch: noarch

# https://github.com/trentm/python-markdown2.git
Source: %modulename-%version.zip

BuildRequires(pre): rpm-build-python3 rpm-build-licenses
BuildRequires: unzip python3-module-pytest

%py3_provides %modulename
%py3_requires logging pygments


%description
This project provides a converter written in Python that closely matches
the behaviour of the original Perl-implemented Markdown.pl. There is
another Python markdown.py, but markdown2.py is faster and, to my
knowledge, more correct.

%package tests
Summary: Tests for markdown2
Group: Development/Python3
BuildArch: noarch
Requires: %name = %version-%release

%description tests
This project provides a converter written in Python that closely matches
the behaviour of the original Perl-implemented Markdown.pl. There is
another Python markdown.py, but markdown2.py is faster and, to my
knowledge, more correct.

This package contains tests for markdown2.

%prep
%setup

sed -i 's|#!/usr/bin/env python.*|#!/usr/bin/env python3|' \
    $(find ./ -name '*.py')

%build
%python3_build

%install
%python3_install
rm -f %buildroot%python3_sitelibdir/*.pyo

%check
%__python3 setup.py test
export PYTHONPATH=$PWD/lib
py.test-%_python3_version -vv

%files
%doc *.txt
%_bindir/markdown2
%python3_sitelibdir/*

%files tests
%doc test/*


%changelog
