%define oname m2crypto

%ifnarch %ix86 armh
%def_with check
%else
%def_without check
%endif

Name: python3-module-%oname
Version: 0.46.2
Release: alt1

Summary: Support for using OpenSSL in python scripts.

License: BSD
Group: Development/Python3
URL: http://wiki.osafoundation.org/bin/view/Projects/MeTooCrypto

# https://gitlab.com/m2crypto/m2crypto.git
Source: %name-%version.tar

BuildRequires: libssl-devel swig
BuildRequires: /usr/bin/openssl
BuildRequires(pre): rpm-build-python3
BuildRequires: python3-module-py
BuildRequires: libnumpy-py3-devel

%add_python3_req_skip M2Crypto.six.moves.http_client
%add_python3_req_skip M2Crypto.six.moves.http_cookies
%add_python3_req_skip M2Crypto.six.moves.socketserver
%add_python3_req_skip M2Crypto.six.moves.urllib_parse
%add_python3_req_skip M2Crypto.six.moves.urllib_response
%add_python3_req_skip M2Crypto.six.moves.xmlrpc_client
%py3_requires typing

%if_with check
BuildRequires: python3-module-pytest
BuildRequires: python3-module-parameterized
%endif

%description
This package allows you to call OpenSSL functions from python scripts.

%prep
%setup

%build
if pkg-config openssl ; then
	FLAGS="$(pkg-config --cflags openssl)"
	%add_optflags $FLAGS
	LDFLAGS="$LDFLAGS`pkg-config --libs-only-L openssl`" ; export LDFLAGS
fi

%python3_build

%install
if pkg-config openssl ; then
	FLAGS="$(pkg-config --cflags openssl)"
	%add_optflags $FLAGS
	LDFLAGS="$LDFLAGS`pkg-config --libs-only-L openssl`" ; export LDFLAGS
fi

%python3_build_install

%check
export PYTHONPATH=%buildroot%python3_sitelibdir
py.test-3 -v

%files
%doc CHANGES README.rst tests doc/*
%python3_sitelibdir/M2Crypto
%python3_sitelibdir/M2Crypto-%version-py%_python3_version.egg-info

%changelog
