%define _unpackaged_files_terminate_build 1
%define oname lz4

%def_with check

Name: python3-module-%oname
Version: 4.3.3
Release: alt1.1

Summary: LZ4 Bindings for Python

License: BSD
Group: Development/Python3
Url: https://pypi.org/project/lz4/

# Source-url: %__pypi_url %oname
Source: %name-%version.tar

BuildRequires(pre): rpm-build-intro
BuildRequires(pre): rpm-build-python3

BuildRequires: python3(pkgconfig)
BuildRequires: python3(setuptools_scm)
BuildRequires: py3c-devel
BuildRequires: liblz4-devel

%if_with check
BuildRequires: /proc
BuildRequires: python3(psutil)
BuildRequires: python3(pytest_cov)
BuildRequires: python3(tox)
%endif

%description
This package provides bindings for the lz4 compression library by Yann
Collet.

%prep
%setup
# remove bundled libs in favor of system ones
rm -r lz4libs

%build
# SETUPTOOLS_SCM_PRETEND_VERSION: when defined and not empty,
# its used as the primary source for the version number in which
# case it will be a unparsed string
export SETUPTOOLS_SCM_PRETEND_VERSION=%version
%python3_build_debug

%install
export SETUPTOOLS_SCM_PRETEND_VERSION=%version
%python3_install

%check
%if_with check
%python3_check
%endif

%files
%doc *.rst
%python3_sitelibdir/lz4-%version-py%_python3_version.egg-info/
%python3_sitelibdir/lz4/

%changelog
