%define oname lmoments3

%def_with check

Name: python3-module-%oname
Version: 1.0.8
Release: alt1.1
Summary: Estimate linear moments for statistical distribution functions
License: GPLv3
Group: Development/Python3
URL: https://pypi.org/project/lmoments3
VCS: https://github.com/OpenHydrology/lmoments3
Source: %name-%version.tar

BuildArch: noarch

BuildRequires(pre): rpm-build-python3
BuildRequires: python3-module-setuptools
BuildRequires: python3-module-setuptools-scm
BuildRequires: python3-module-wheel

%if_with check
BuildPreReq: python3(numpy)
BuildPreReq: python3(numpy.testing)
BuildPreReq: python3(scipy)
BuildRequires: python3-module-pytest
%endif

%description
This library was designed to use L-moments to calculate optimal
parameters for a number of distributions. This library extends a number
of scipy distributions and provides some additional distributions
frequently used in Extreme Value Analyses.

%prep
%setup

%build
export SETUPTOOLS_SCM_PRETEND_VERSION=%version
%pyproject_build

%install
%pyproject_install

%check
%tox_create_default_config
%tox_check_pyproject

%files
%doc LICENSE *.rst docs/source/*.rst
%python3_sitelibdir/%oname
%python3_sitelibdir/%oname-%version.dist-info

%changelog
