%define  oname llvmlite
%define  llvm_version 20.1
%define  clang_version %(echo %llvm_version | cut -d . -f 1)
%define  optflags_lto -flto=thin

#[armh] LLVM ERROR: Symbol not found: __aeabi_unwind_cpp_pr0
%ifnarch armh
%def_with check
%else
%def_without check
%endif

Name:    python3-module-%oname
Version: 0.45.1
Release: alt1

Summary: A lightweight LLVM python binding for writing JIT compilers

License: BSD-2-Clause
Group:   Development/Python3
URL:     https://pypi.org/project/llvmlite
VCS:     https://github.com/numba/llvmlite

Packager: Grigory Ustinov <grenka@altlinux.org>

BuildRequires: clang%{llvm_version} llvm%{llvm_version}-devel libstdc++-devel lld%{llvm_version}
BuildRequires: cmake
BuildRequires(pre): rpm-build-python3
BuildRequires: python3-module-setuptools
BuildRequires: python3-module-wheel
BuildRequires: zlib-devel

Source:  %name-%version.tar

Patch: llvmlite-alt-normalize-i586-name.patch

%description
A lightweight LLVM python binding for writing JIT compilers

The old llvmpy  binding exposes a lot of LLVM APIs but the mapping of
C++-style memory management to Python is error prone. Numba_ and many JIT
compilers do not need a full LLVM API.  Only the IR builder, optimizer,
and JIT compiler APIs are necessary.

llvmlite is a project originally tailored for Numba's needs, using the
following approach:

* A small C wrapper around the parts of the LLVM C++ API we need that are
  not already exposed by the LLVM C API.
* A ctypes Python wrapper around the C API.
* A pure Python implementation of the subset of the LLVM IR builder that we
  need for Numba.

%prep
%setup
%patch -p1

sed -i 's|"version": "0+unknown"|"version": "%version"|' versioneer.py

%build
export ALTWRAP_LLVM_VERSION=%{llvm_version}
export CXX=/usr/bin/clang++-%{clang_version}
export CC=/usr/bin/clang-%{clang_version}
%pyproject_build

%install
%pyproject_install

%check
%__python3 ./runtests.py

%files
%doc LICENSE CHANGE_LOG *.rst
%python3_sitelibdir/%oname
%python3_sitelibdir/%{pyproject_distinfo %oname}

%changelog
